/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;

public class SetReservedSpaceOperation
extends PageBasicOperation {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1999, 2004.";
    protected int doMeSlot;
    protected int recordId;
    protected int newValue;
    protected int oldValue;

    public int getTypeFormatId() {
        return 287;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        CompressedNumber.writeInt(objectOutput, this.recordId);
        CompressedNumber.writeInt(objectOutput, this.newValue);
        CompressedNumber.writeInt(objectOutput, this.oldValue);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
        this.newValue = CompressedNumber.readInt(objectInput);
        this.oldValue = CompressedNumber.readInt(objectInput);
    }

    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.setReservedSpace(logInstant, this.doMeSlot, this.newValue);
    }

    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n = basePage.findRecordById(this.recordId, 0);
        this.page.setReservedSpace(logInstant, n, this.oldValue);
    }

    public String toString() {
        return null;
    }

    public SetReservedSpaceOperation(BasePage basePage, int n, int n2, int n3, int n4) {
        super(basePage);
        this.doMeSlot = n;
        this.recordId = n2;
        this.newValue = n3;
        this.oldValue = n4;
    }

    public SetReservedSpaceOperation() {
    }
}

