/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.CRC32;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.context.ErrorStringBuilder;
import org.apache.derby.iapi.services.context.ShutdownException;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.log.LogScan;
import org.apache.derby.iapi.store.raw.log.Logger;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.store.raw.log.CheckpointOperation;
import org.apache.derby.impl.store.raw.log.FileLogger;
import org.apache.derby.impl.store.raw.log.FlushedScan;
import org.apache.derby.impl.store.raw.log.FlushedScanHandle;
import org.apache.derby.impl.store.raw.log.LogAccessFile;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.SaveLWMOperation;
import org.apache.derby.impl.store.raw.log.Scan;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.impl.store.raw.log.TruncationPoint;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.io.WritableStorageFactory;

public class LogToFile
implements LogFactory,
ModuleControl,
ModuleSupportable,
Serviceable,
PrivilegedExceptionAction {
    private static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static int fid = 128;
    public static final int LOG_FILE_HEADER_SIZE = 24;
    protected static final int LOG_FILE_HEADER_PREVIOUS_LOG_INSTANT_OFFSET = 16;
    public static final int LOG_RECORD_OVERHEAD = 16;
    public static final String DBG_FLAG = null;
    public static final String DUMP_LOG_ONLY = null;
    public static final String DUMP_LOG_FROM_LOG_FILE = null;
    protected static final String LOG_SYNC_STATISTICS = "LogSyncStatistics";
    private static final int OBSOLETE_LOG_VERSION_NUMBER = 9;
    private static final int DEFAULT_LOG_SWITCH_INTERVAL = 0x100000;
    private static final int LOG_SWITCH_INTERVAL_MIN = 100000;
    private static final int LOG_SWITCH_INTERVAL_MAX = 0x8000000;
    private static final int CHECKPOINT_INTERVAL_MIN = 100000;
    private static final int CHECKPOINT_INTERVAL_MAX = 0x8000000;
    private static final int DEFAULT_CHECKPOINT_INTERVAL = 0xA00000;
    private static final int DEFAULT_LOG_BUFFER_SIZE = 32768;
    private static final int LOG_BUFFER_SIZE_MIN = 8192;
    private static final int LOG_BUFFER_SIZE_MAX = 0x8000000;
    private static final byte IS_BETA_FLAG = 1;
    private static final String DEFAULT_LOG_ARCHIVE_DIRECTORY = "DEFAULT";
    public static final String TEST_LOG_SWITCH_LOG = null;
    public static final String TEST_LOG_INCOMPLETE_LOG_WRITE = null;
    public static final String TEST_LOG_PARTIAL_LOG_WRITE_NUM_BYTES = null;
    public static final String TEST_LOG_FULL = null;
    public static final String TEST_SWITCH_LOG_FAIL1 = null;
    public static final String TEST_SWITCH_LOG_FAIL2 = null;
    public static final String TEST_RECORD_TO_FILL_LOG = null;
    private int logBufferSize = 32768;
    private int logSwitchInterval = 0x100000;
    private int checkpointInterval = 0xA00000;
    String dataDirectory;
    private WritableStorageFactory logStorageFactory;
    private boolean logBeingFlushed;
    protected LogAccessFile logOut;
    protected long endPosition = -1L;
    long lastFlush = 0L;
    long logFileNumber = -1L;
    long firstLogFileNumber = -1L;
    private CheckpointOperation currentCheckpoint;
    long checkpointInstant;
    private DaemonService checkpointDaemon;
    private int myClientNumber;
    private volatile boolean checkpointDaemonCalled;
    private long logWrittenFromLastCheckPoint = 0L;
    private RawStoreFactory rawStoreFactory;
    protected DataFactory dataFactory;
    protected boolean ReadOnlyDB;
    private boolean keepAllLogs;
    private boolean databaseEncrypted;
    private boolean recoveryNeeded = true;
    private boolean inCheckpoint = false;
    private boolean inRedo = false;
    private boolean movingTruncPt = false;
    private boolean inLogSwitch = false;
    private boolean stopped = false;
    Vector truncPoints;
    String logDevice;
    private boolean logNotSynced = false;
    private boolean logArchived = false;
    private boolean logSwitchRequired = false;
    int test_logWritten = 0;
    int test_numRecordToFillLog = -1;
    private int mon_flushCalls;
    private int mon_syncCalls;
    private int mon_numLogFlushWaits;
    private boolean mon_LogSyncStatistics;
    private int mon_numBytesToLog;
    protected volatile StandardException corrupt;
    private boolean isFrozen;
    ProductVersionHolder jbmsVersion;
    private int onDiskMajorVersion;
    private int onDiskMinorVersion;
    private boolean onDiskBeta;
    private CRC32 checksum = new CRC32();
    private boolean isWriteSynced = false;
    private int action;
    private StorageFile activeFile;
    private File toFile;
    private String activePerms;

    public int getTypeFormatId() {
        return 128;
    }

    public StandardException markCorrupt(StandardException standardException) {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt == null && standardException != null) {
                this.corrupt = standardException;
                bl = true;
            }
        }
        if (this.corrupt == standardException) {
            this.logErrMsg(this.corrupt);
        }
        if (bl) {
            LogToFile logToFile2 = this;
            synchronized (logToFile2) {
                this.stopped = true;
                if (this.logOut != null) {
                    try {
                        this.logOut.corrupt();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.logOut = null;
            }
            if (this.dataFactory != null) {
                this.dataFactory.markCorrupt(null);
            }
        }
        return standardException;
    }

    private void checkCorrupt() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                throw StandardException.newException("XSLAA.D", this.corrupt);
            }
        }
    }

    public Logger getLogger() {
        if (this.ReadOnlyDB) {
            return null;
        }
        return new FileLogger(this);
    }

    public void recover(RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory) throws StandardException {
        this.checkCorrupt();
        this.rawStoreFactory = rawStoreFactory;
        this.dataFactory = dataFactory;
        if (this.recoveryNeeded) {
            try {
                StorageFile storageFile;
                RawTransaction rawTransaction;
                FileLogger fileLogger = (FileLogger)this.getLogger();
                if (this.checkpointInstant != 0L) {
                    this.currentCheckpoint = this.findCheckpoint(this.checkpointInstant, fileLogger);
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                StreamLogScan streamLogScan = null;
                if (this.currentCheckpoint != null) {
                    LogInstant logInstant;
                    TruncationPoint[] truncationPointArray;
                    rawTransaction = null;
                    transactionFactory.useTransactionTable((Formatable)((Object)rawTransaction));
                    l = this.currentCheckpoint.redoLWM();
                    l2 = this.currentCheckpoint.undoLWM();
                    if (rawTransaction != null) {
                        l3 = this.checkpointInstant;
                    }
                    this.firstLogFileNumber = LogCounter.getLogFileNumber(l);
                    if (LogCounter.getLogFileNumber(l2) < this.firstLogFileNumber) {
                        this.firstLogFileNumber = LogCounter.getLogFileNumber(l2);
                    }
                    if ((truncationPointArray = this.currentCheckpoint.truncationLWM()) != null && (logInstant = this.restoreTruncationLWMs(truncationPointArray)) != null && ((LogCounter)logInstant).getLogFileNumber() < this.firstLogFileNumber) {
                        this.firstLogFileNumber = ((LogCounter)logInstant).getLogFileNumber();
                    }
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l2, null);
                } else {
                    transactionFactory.useTransactionTable(null);
                    long l4 = LogCounter.makeLogInstantAsLong(this.logFileNumber, 24L);
                    this.firstLogFileNumber = this.logFileNumber;
                    streamLogScan = (StreamLogScan)this.openForwardsScan(l4, null);
                }
                rawTransaction = transactionFactory.startTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
                rawTransaction.recoveryTransaction();
                this.inRedo = true;
                long l5 = fileLogger.redo(rawTransaction, transactionFactory, streamLogScan, l, l3);
                this.inRedo = false;
                StorageRandomAccessFile storageRandomAccessFile = null;
                if (l5 == 0L) {
                    Monitor.logTextMessage("L007");
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        storageFile = this.getLogFileName(++this.logFileNumber);
                    }
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                        }
                        storageRandomAccessFile = null;
                        this.ReadOnlyDB = true;
                    } else {
                        try {
                            if (!this.initLogFile(storageRandomAccessFile, this.logFileNumber, 0L)) {
                                throw this.markCorrupt(StandardException.newException("XSLAQ.D", storageFile.getPath()));
                            }
                        }
                        catch (IOException iOException) {
                            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
                        }
                        this.lastFlush = this.endPosition = storageRandomAccessFile.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logSwitchRequired = false;
                    }
                } else {
                    this.logFileNumber = LogCounter.getLogFileNumber(l5);
                    this.ReadOnlyDB = dataFactory.isReadOnly();
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (!this.ReadOnlyDB) {
                        try {
                            storageRandomAccessFile = this.isWriteSynced ? this.privRandomAccessFile(storageFile, "rws") : this.privRandomAccessFile(storageFile, "rw");
                        }
                        catch (IOException iOException) {
                            storageRandomAccessFile = null;
                        }
                        if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                            if (storageRandomAccessFile != null) {
                                storageRandomAccessFile.close();
                            }
                            storageRandomAccessFile = null;
                            this.ReadOnlyDB = true;
                        }
                    }
                    if (!this.ReadOnlyDB) {
                        this.endPosition = LogCounter.getLogFilePosition(l5);
                        if (streamLogScan.isLogEndFuzzy()) {
                            storageRandomAccessFile.seek(this.endPosition);
                            long l6 = storageRandomAccessFile.length();
                            Monitor.logTextMessage("L010", storageFile, new Long(this.endPosition), new Long(l6));
                            long l7 = (l6 - this.endPosition) / (long)this.logBufferSize;
                            int n = (int)((l6 - this.endPosition) % (long)this.logBufferSize);
                            byte[] byArray = new byte[this.logBufferSize];
                            while (l7-- > 0L) {
                                storageRandomAccessFile.write(byArray);
                            }
                            if (n != 0) {
                                storageRandomAccessFile.write(byArray, 0, n);
                            }
                            if (!this.isWriteSynced) {
                                this.syncFile(storageRandomAccessFile);
                            }
                        }
                        this.lastFlush = this.endPosition;
                        storageRandomAccessFile.seek(this.endPosition);
                    }
                }
                if (storageRandomAccessFile != null) {
                    this.logOut = new LogAccessFile(storageRandomAccessFile, this.logBufferSize);
                }
                if (this.logSwitchRequired) {
                    this.switchLogFile();
                }
                boolean bl = transactionFactory.noActiveUpdateTransaction();
                if (this.ReadOnlyDB && !bl) {
                    throw StandardException.newException("XSLAF.D");
                }
                if (!bl) {
                    transactionFactory.rollbackAllTransactions(rawTransaction, rawStoreFactory);
                }
                transactionFactory.handlePreparedXacts(rawStoreFactory);
                rawTransaction.close();
                this.dataFactory.postRecovery();
                transactionFactory.resetTranId();
                if (!this.ReadOnlyDB) {
                    boolean bl2 = true;
                    if (this.currentCheckpoint != null && bl && l != 0L && l2 != 0L && this.logFileNumber == LogCounter.getLogFileNumber(l) && this.logFileNumber == LogCounter.getLogFileNumber(l2) && this.endPosition < LogCounter.getLogFilePosition(l) + 1000L) {
                        bl2 = false;
                    }
                    if (bl2 && !this.checkpoint(rawStoreFactory, dataFactory, transactionFactory, false)) {
                        this.flush(this.logFileNumber, this.endPosition);
                    }
                }
                fileLogger.close();
                this.recoveryNeeded = false;
            }
            catch (IOException iOException) {
                throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException));
            }
            catch (StandardException standardException) {
                throw this.markCorrupt(standardException);
            }
            catch (Throwable throwable) {
                throw this.markCorrupt(StandardException.newException("XSLA6.D", throwable));
            }
        }
        transactionFactory.useTransactionTable(null);
        transactionFactory.resetTranId();
        this.checkpointDaemon = this.rawStoreFactory.getDaemon();
        if (this.checkpointDaemon != null) {
            this.myClientNumber = this.checkpointDaemon.subscribe(this, true);
        }
    }

    public boolean checkpoint(RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory, boolean bl) throws StandardException {
        boolean bl2 = this.checkpointWithTran(null, rawStoreFactory, dataFactory, transactionFactory);
        if (!bl2 && bl) {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                while (this.inCheckpoint) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * Loose catch block
     */
    protected boolean checkpointWithTran(RawTransaction rawTransaction, RawStoreFactory rawStoreFactory, DataFactory dataFactory, TransactionFactory transactionFactory) throws StandardException {
        block38: {
            LogToFile logToFile;
            long l;
            boolean bl = true;
            if (this.logOut == null) {
                return false;
            }
            LogToFile logToFile2 = this;
            synchronized (logToFile2) {
                if (this.corrupt != null) {
                    throw StandardException.newException("XSLAA.D", this.corrupt);
                }
                if (this.inCheckpoint) {
                    bl = false;
                } else {
                    this.inCheckpoint = true;
                }
                l = this.endPosition;
            }
            if (!bl) {
                return false;
            }
            boolean bl2 = rawTransaction == null;
            try {
                Object object;
                long l2;
                Formatable formatable;
                LogCounter logCounter;
                long l3;
                if (l > (long)this.logSwitchInterval) {
                    this.switchLogFile();
                    this.logWrittenFromLastCheckPoint = 0L;
                } else {
                    this.logWrittenFromLastCheckPoint = -this.endPosition;
                }
                if (bl2) {
                    rawTransaction = transactionFactory.startInternalTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager());
                }
                LogToFile logToFile3 = this;
                synchronized (logToFile3) {
                    l3 = this.currentInstant();
                    logCounter = new LogCounter(l3);
                    formatable = (LogCounter)transactionFactory.firstUpdateInstant();
                    l2 = formatable == null ? l3 : formatable.getValueAsLong();
                }
                dataFactory.checkpoint();
                formatable = transactionFactory.getTransactionTable();
                TruncationPoint[] truncationPointArray = null;
                logToFile3 = this;
                synchronized (logToFile3) {
                    if (this.truncPoints != null) {
                        int n = this.truncPoints.size();
                        truncationPointArray = new TruncationPoint[n];
                        int n2 = 0;
                        while (n2 < n) {
                            object = (TruncationPoint)this.truncPoints.elementAt(n2);
                            truncationPointArray[n2] = new TruncationPoint(((TruncationPoint)object).getName(), ((TruncationPoint)object).getLogInstant());
                            ++n2;
                        }
                    }
                }
                CheckpointOperation checkpointOperation = new CheckpointOperation(l3, l2, truncationPointArray, formatable);
                rawTransaction.logAndDo(checkpointOperation);
                object = (LogCounter)rawTransaction.getLastLogInstant();
                if (object == null) {
                    throw StandardException.newException("XSLAI.D");
                }
                this.flush((LogInstant)object);
                rawTransaction.commit();
                if (bl2) {
                    rawTransaction.close();
                    rawTransaction = null;
                }
                if (!this.writeControlFile(this.getControlFileName(), ((LogCounter)object).getValueAsLong())) {
                    throw StandardException.newException("XSLAE.D", this.getControlFileName());
                }
                this.currentCheckpoint = checkpointOperation;
                if (!this.logArchived()) {
                    this.truncateLog(this.currentCheckpoint);
                }
                dataFactory.removeDroppedContainerFileStubs(logCounter);
                Object var10_23 = null;
                logToFile = this;
            }
            catch (Throwable throwable) {
                Object var10_24 = null;
                LogToFile logToFile4 = this;
                synchronized (logToFile4) {
                    this.inCheckpoint = false;
                    this.notifyAll();
                }
                if (rawTransaction != null && bl2) {
                    try {
                        rawTransaction.commit();
                        rawTransaction.close();
                    }
                    catch (StandardException standardException) {
                        throw this.markCorrupt(StandardException.newException("XSLA3.D", standardException));
                    }
                }
                throw throwable;
            }
            synchronized (logToFile) {
                this.inCheckpoint = false;
                this.notifyAll();
            }
            if (rawTransaction != null && bl2) {
                try {
                    rawTransaction.commit();
                    rawTransaction.close();
                }
                catch (StandardException standardException) {
                    throw this.markCorrupt(StandardException.newException("XSLA3.D", standardException));
                }
            }
            break block38;
            {
                catch (IOException iOException) {
                    throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
                }
            }
        }
        return true;
    }

    public void flush(LogInstant logInstant) throws StandardException {
        long l;
        long l2;
        if (logInstant == null) {
            l2 = 0L;
            l = 0L;
        } else {
            LogCounter logCounter = (LogCounter)logInstant;
            l2 = logCounter.getLogFileNumber();
            l = logCounter.getLogFilePosition();
        }
        this.flush(l2, l);
    }

    public void flushAll() throws StandardException {
        long l;
        long l2;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            l2 = this.logFileNumber;
            l = this.endPosition;
        }
        this.flush(l2, l);
    }

    private boolean verifyLogFormat(StorageFile storageFile, long l) throws StandardException {
        boolean bl = false;
        try {
            StorageRandomAccessFile storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            bl = this.verifyLogFormat(storageRandomAccessFile, l);
            storageRandomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private boolean verifyLogFormat(StorageRandomAccessFile storageRandomAccessFile, long l) throws StandardException {
        try {
            storageRandomAccessFile.seek(0L);
            int n = storageRandomAccessFile.readInt();
            int n2 = storageRandomAccessFile.readInt();
            long l2 = storageRandomAccessFile.readLong();
            if (n != fid || l2 != l) {
                throw StandardException.newException("XSLAC.D", this.dataDirectory);
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSLAM.D", iOException, (Object)this.dataDirectory);
        }
        return true;
    }

    private boolean initLogFile(StorageRandomAccessFile storageRandomAccessFile, long l, long l2) throws IOException, StandardException {
        if (storageRandomAccessFile.length() != 0L) {
            return false;
        }
        storageRandomAccessFile.seek(0L);
        storageRandomAccessFile.writeInt(fid);
        storageRandomAccessFile.writeInt(9);
        storageRandomAccessFile.writeLong(l);
        storageRandomAccessFile.writeLong(l2);
        this.syncFile(storageRandomAccessFile);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchLogFile() throws StandardException {
        boolean bl = false;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            block22: {
                StorageFile storageFile;
                if (this.endPosition == 24L) {
                    return;
                }
                boolean bl2 = false;
                while (true) {
                    if (!(this.logBeingFlushed | this.isFrozen)) {
                        storageFile = this.getLogFileName(this.logFileNumber + 1L);
                        if (this.logFileNumber + 1L < 0x3FFFFFL) break;
                        throw StandardException.newException("XSLAK.D", new Long(0x3FFFFFL));
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (this.privExists(storageFile) && !this.privDelete(storageFile)) {
                        this.logErrMsg(MessageService.getTextMessage("L015", storageFile.getPath()));
                        return;
                    }
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    if (storageRandomAccessFile == null || !this.privCanWrite(storageFile)) {
                        if (storageRandomAccessFile == null) return;
                        storageRandomAccessFile.close();
                        return;
                    }
                    if (this.initLogFile(storageRandomAccessFile, this.logFileNumber + 1L, LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition))) {
                        bl = true;
                        this.logOut.writeInt(0);
                        this.endPosition += 4L;
                        this.inLogSwitch = true;
                        this.flush(this.logFileNumber, this.endPosition);
                        this.logOut.close();
                        this.logWrittenFromLastCheckPoint += this.endPosition;
                        this.lastFlush = this.endPosition = storageRandomAccessFile.getFilePointer();
                        if (this.isWriteSynced) {
                            this.preAllocateNewLogFile(storageRandomAccessFile);
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
                            storageRandomAccessFile.seek(this.endPosition);
                        }
                        this.logOut = new LogAccessFile(storageRandomAccessFile, this.logBufferSize);
                        storageRandomAccessFile = null;
                        ++this.logFileNumber;
                    } else {
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                        if (this.privExists(storageFile)) {
                            this.privDelete(storageFile);
                        }
                        storageFile = null;
                        this.logErrMsg(MessageService.getTextMessage("L016", storageFile.getPath()));
                    }
                }
                catch (IOException iOException) {
                    this.inLogSwitch = false;
                    this.logErrMsg(MessageService.getTextMessage("L017", storageFile.getPath(), iOException.toString()));
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageRandomAccessFile = null;
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    if (storageFile != null && this.privExists(storageFile)) {
                        this.privDelete(storageFile);
                        storageFile = null;
                    }
                    if (!bl) break block22;
                    this.logOut = null;
                    throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
                }
            }
            this.inLogSwitch = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flushBuffer(long l, long l2) throws IOException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (l < this.logFileNumber) {
                return;
            }
            if (l2 < this.lastFlush) return;
            this.logOut.flushLogAccessFile();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void truncateLog(CheckpointOperation checkpointOperation) {
        if (this.keepAllLogs) {
            return;
        }
        long l = this.getFirstLogNeeded(checkpointOperation);
        if (l == -1L) {
            return;
        }
        long l2 = this.firstLogFileNumber;
        this.firstLogFileNumber = l;
        while (l2 < l) {
            StorageFile storageFile = null;
            try {
                storageFile = this.getLogFileName(l2);
                if (!this.privDelete(storageFile)) {
                    // empty if block
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            ++l2;
        }
    }

    private long getFirstLogNeeded(CheckpointOperation checkpointOperation) {
        long l;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            LogCounter logCounter;
            Object object;
            int n;
            if (this.movingTruncPt) {
                long l2 = -1L;
                Object var5_4 = null;
                return l2;
            }
            l = LogCounter.getLogFileNumber(checkpointOperation.undoLWM());
            if (this.truncPoints != null) {
                n = this.truncPoints.size() - 1;
                while (n >= 0) {
                    object = (TruncationPoint)this.truncPoints.elementAt(n);
                    logCounter = (LogCounter)((TruncationPoint)object).getLogInstant();
                    if (l > logCounter.getLogFileNumber()) {
                        l = logCounter.getLogFileNumber();
                    }
                    --n;
                }
            }
            if ((object = checkpointOperation.truncationLWM()) != null) {
                n = ((TruncationPoint[])object).length - 1;
                while (n >= 0) {
                    logCounter = (LogCounter)object[n].getLogInstant();
                    if (l > logCounter.getLogFileNumber()) {
                        l = logCounter.getLogFileNumber();
                    }
                    --n;
                }
            }
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeControlFile(StorageFile storageFile, long l) throws IOException, StandardException {
        StorageRandomAccessFile storageRandomAccessFile;
        block10: {
            boolean bl;
            block9: {
                storageRandomAccessFile = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(64);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(fid);
                dataOutputStream.writeInt(9);
                dataOutputStream.writeLong(l);
                if (this.onDiskMajorVersion == 0) {
                    this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
                    this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
                    this.onDiskBeta = this.jbmsVersion.isBeta();
                }
                dataOutputStream.writeInt(this.onDiskMajorVersion);
                dataOutputStream.writeInt(this.onDiskMinorVersion);
                dataOutputStream.writeInt(this.jbmsVersion.getBuildNumber());
                int n = 0;
                if (this.onDiskBeta) {
                    n = (byte)(n | 1);
                }
                dataOutputStream.writeByte(n);
                long l2 = 0L;
                dataOutputStream.writeByte(0);
                dataOutputStream.writeByte(0);
                dataOutputStream.writeByte(0);
                dataOutputStream.writeLong(l2);
                dataOutputStream.flush();
                this.checksum.reset();
                this.checksum.update(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
                dataOutputStream.writeLong(this.checksum.getValue());
                dataOutputStream.flush();
                try {
                    this.checkCorrupt();
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                        boolean bl2 = false;
                        Object var11_13 = null;
                        if (storageRandomAccessFile == null) return bl2;
                        storageRandomAccessFile.close();
                        return bl2;
                    }
                    if (!this.privCanWrite(storageFile)) {
                        bl = false;
                        Object var11_14 = null;
                        if (storageRandomAccessFile == null) return bl;
                        break block9;
                    }
                    storageRandomAccessFile.seek(0L);
                    storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
                    this.syncFile(storageRandomAccessFile);
                    storageRandomAccessFile.close();
                    try {
                        storageRandomAccessFile = this.privRandomAccessFile(this.getMirrorControlFileName(), "rw");
                    }
                    catch (IOException iOException) {
                        storageRandomAccessFile = null;
                        boolean bl3 = false;
                        Object var11_15 = null;
                        if (storageRandomAccessFile == null) return bl3;
                        storageRandomAccessFile.close();
                        return bl3;
                    }
                    storageRandomAccessFile.seek(0L);
                    storageRandomAccessFile.write(byteArrayOutputStream.toByteArray());
                    this.syncFile(storageRandomAccessFile);
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var11_17 = null;
                    if (storageRandomAccessFile == null) throw throwable;
                    storageRandomAccessFile.close();
                    throw throwable;
                }
            }
            storageRandomAccessFile.close();
            return bl;
        }
        Object var11_16 = null;
        if (storageRandomAccessFile == null) return true;
        storageRandomAccessFile.close();
        return true;
    }

    private long readControlFile(StorageFile storageFile, Properties properties) throws IOException, StandardException {
        long l;
        boolean bl;
        FilterInputStream filterInputStream;
        ByteArrayInputStream byteArrayInputStream;
        StorageRandomAccessFile storageRandomAccessFile;
        block20: {
            storageRandomAccessFile = null;
            byteArrayInputStream = null;
            filterInputStream = null;
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            bl = false;
            l = 0L;
            long l2 = 0L;
            long l3 = storageRandomAccessFile.length();
            byte[] byArray = null;
            try {
                boolean bl2;
                if (l3 < 16L) {
                    l2 = -1L;
                } else if (l3 == 16L) {
                    byArray = new byte[16];
                    storageRandomAccessFile.readFully(byArray);
                } else if (l3 > 16L) {
                    byArray = new byte[(int)storageRandomAccessFile.length() - 8];
                    storageRandomAccessFile.readFully(byArray);
                    l2 = storageRandomAccessFile.readLong();
                    if (l2 != 0L) {
                        this.checksum.reset();
                        this.checksum.update(byArray, 0, byArray.length);
                    }
                }
                if (l2 != this.checksum.getValue() && l2 != 0L) break block20;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                if (((DataInputStream)filterInputStream).readInt() != fid) {
                    throw StandardException.newException("XSLAC.D", this.dataDirectory);
                }
                int n = ((DataInputStream)filterInputStream).readInt();
                l = ((DataInputStream)filterInputStream).readLong();
                this.onDiskMajorVersion = ((DataInputStream)filterInputStream).readInt();
                this.onDiskMinorVersion = ((DataInputStream)filterInputStream).readInt();
                int n2 = ((DataInputStream)filterInputStream).readInt();
                byte by = ((DataInputStream)filterInputStream).readByte();
                boolean bl3 = this.onDiskBeta = (by & 1) != 0;
                if (!(!this.onDiskBeta || this.jbmsVersion.isBeta() && this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion == this.jbmsVersion.getMinorVersion() || (bl2 = false))) {
                    throw StandardException.newException("XSLAP.D", this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta));
                }
                if (this.onDiskMajorVersion > this.jbmsVersion.getMajorVersion() || this.onDiskMajorVersion == this.jbmsVersion.getMajorVersion() && this.onDiskMinorVersion > this.jbmsVersion.getMinorVersion()) {
                    throw StandardException.newException("XSLAN.D", this.dataDirectory, (Object)ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta));
                }
                if (this.onDiskMajorVersion != this.jbmsVersion.getMajorVersion() || this.onDiskMinorVersion != this.jbmsVersion.getMinorVersion()) {
                    bl = true;
                }
                if (l2 != 0L || this.onDiskMajorVersion <= 3 && this.onDiskMinorVersion <= 5 && this.onDiskMajorVersion != 0) break block20;
                l = 0L;
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                throw throwable;
            }
        }
        Object var15_15 = null;
        if (storageRandomAccessFile != null) {
            storageRandomAccessFile.close();
        }
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        if (filterInputStream != null) {
            filterInputStream.close();
        }
        if (bl && Monitor.isFullUpgrade(properties, ProductVersionHolder.simpleVersionString(this.onDiskMajorVersion, this.onDiskMinorVersion, this.onDiskBeta))) {
            this.onDiskMajorVersion = this.jbmsVersion.getMajorVersion();
            this.onDiskMinorVersion = this.jbmsVersion.getMinorVersion();
            this.onDiskBeta = this.jbmsVersion.isBeta();
            if (!this.writeControlFile(storageFile, l)) {
                throw StandardException.newException("XSLAE.D", storageFile);
            }
        }
        return l;
    }

    public StorageFile getLogDirectory() throws StandardException {
        StorageFile storageFile = null;
        storageFile = this.logStorageFactory.newStorageFile("log");
        if (!this.privExists(storageFile) && !this.privMkdirs(storageFile)) {
            throw StandardException.newException("XSLAQ.D", storageFile.getPath());
        }
        return storageFile;
    }

    public String getCanonicalLogPath() {
        if (this.logDevice == null) {
            return null;
        }
        try {
            return this.logStorageFactory.getCanonicalName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private StorageFile getControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log.ctrl");
    }

    private StorageFile getMirrorControlFileName() throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "logmirror.ctrl");
    }

    private StorageFile getLogFileName(long l) throws StandardException {
        return this.logStorageFactory.newStorageFile(this.getLogDirectory(), "log" + l + ".dat");
    }

    private CheckpointOperation findCheckpoint(long l, FileLogger fileLogger) throws IOException, StandardException, ClassNotFoundException {
        StreamLogScan streamLogScan = (StreamLogScan)this.openForwardsScan(l, null);
        Loggable loggable = fileLogger.readLogRecord(streamLogScan, 100);
        streamLogScan.close();
        if (loggable instanceof CheckpointOperation) {
            return (CheckpointOperation)loggable;
        }
        return null;
    }

    protected LogScan openBackwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            return this.openBackwardsScan(logInstant);
        }
        this.flushBuffer(LogCounter.getLogFileNumber(l), LogCounter.getLogFilePosition(l));
        return new Scan(this, l, logInstant, 2);
    }

    protected LogScan openBackwardsScan(LogInstant logInstant) throws IOException, StandardException {
        long l;
        this.checkCorrupt();
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.logOut.flushLogAccessFile();
            l = this.currentInstant();
        }
        return new Scan(this, l, logInstant, 4);
    }

    public ScanHandle openFlushedScan(DatabaseInstant databaseInstant, int n) throws StandardException {
        return new FlushedScanHandle(this, databaseInstant, n);
    }

    protected LogScan openForwardsScan(long l, LogInstant logInstant) throws IOException, StandardException {
        this.checkCorrupt();
        if (l == 0L) {
            l = this.firstLogInstant();
        }
        if (logInstant != null) {
            LogCounter logCounter = (LogCounter)logInstant;
            this.flushBuffer(logCounter.getLogFileNumber(), logCounter.getLogFilePosition());
        } else {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.logOut != null) {
                    this.logOut.flushLogAccessFile();
                }
            }
        }
        return new Scan(this, l, logInstant, 1);
    }

    protected StorageRandomAccessFile getLogFileAtBeginning(long l) throws IOException, StandardException {
        long l2 = LogCounter.makeLogInstantAsLong(l, 24L);
        return this.getLogFileAtPosition(l2);
    }

    protected StorageRandomAccessFile getLogFileAtPosition(long l) throws IOException, StandardException {
        this.checkCorrupt();
        long l2 = LogCounter.getLogFileNumber(l);
        long l3 = LogCounter.getLogFilePosition(l);
        StorageFile storageFile = this.getLogFileName(l2);
        if (!this.privExists(storageFile)) {
            return null;
        }
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            storageRandomAccessFile = this.privRandomAccessFile(storageFile, "r");
            if (!this.verifyLogFormat(storageRandomAccessFile, l2)) {
                storageRandomAccessFile.close();
                storageRandomAccessFile = null;
            } else {
                storageRandomAccessFile.seek(l3);
            }
        }
        catch (IOException iOException) {
            try {
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                    storageRandomAccessFile = null;
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        return storageRandomAccessFile;
    }

    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.__rt.storage.log");
        return string == null || !string.equals("readonly");
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        Object object;
        String string;
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        this.logDevice = properties.getProperty("logDevice");
        if (this.logDevice != null) {
            string = null;
            try {
                object = new URL(this.logDevice);
                string = ((URL)object).getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string != null) {
                this.logDevice = string;
            }
        }
        this.restoreLogs(properties);
        this.logBufferSize = PropertyUtil.getSystemInt("derby.storage.logBufferSize", 8192, 0x8000000, 32768);
        if (this.logStorageFactory == null) {
            this.getLogStorageFactory();
        }
        if (this.logDevice != null) {
            string = null;
            try {
                object = new URL(this.logDevice);
                string = ((URL)object).getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (string != null) {
                this.logDevice = string;
            }
            if (!bl && !this.privExists((StorageFile)(object = this.logStorageFactory.newStorageFile("log")))) {
                throw StandardException.newException("XSLAB.D", object.getPath());
            }
        }
        this.jbmsVersion = Monitor.getMonitor().getEngineVersion();
        string = properties.getProperty("dataEncryption");
        this.databaseEncrypted = Boolean.valueOf(string);
        object = properties.getProperty("derby.storage.logArchiveMode");
        this.logArchived = Boolean.valueOf((String)object);
        this.getLogFactoryProperties(null);
        this.isWriteSynced = this.logStorageFactory.supportsRws() ? !PropertyUtil.getSystemBoolean("derby.storage.fileSyncTransactionLog") : false;
        boolean bl2 = bl;
        this.checkpointInstant = 0L;
        try {
            StorageFile storageFile;
            StorageFile storageFile2 = this.getControlFileName();
            if (!bl2) {
                if (this.privExists(storageFile2)) {
                    this.checkpointInstant = this.readControlFile(storageFile2, properties);
                    if (this.checkpointInstant == 0L && this.getMirrorControlFileName().exists()) {
                        this.checkpointInstant = this.readControlFile(this.getMirrorControlFileName(), properties);
                    }
                } else if (this.logDevice != null) {
                    throw StandardException.newException("XSLAB.D", storageFile2.getPath());
                }
                this.logFileNumber = this.checkpointInstant != 0L ? LogCounter.getLogFileNumber(this.checkpointInstant) : 1L;
                storageFile = this.getLogFileName(this.logFileNumber);
                if (!this.privExists(storageFile)) {
                    if (this.logDevice != null) {
                        throw StandardException.newException("XSLAB.D", storageFile2.getPath());
                    }
                    this.logErrMsg(MessageService.getTextMessage("L018", storageFile.getPath()));
                    bl2 = true;
                } else if (!this.verifyLogFormat(storageFile, this.logFileNumber)) {
                    Monitor.logTextMessage("L008", storageFile);
                    if (!this.privDelete(storageFile) && this.logFileNumber == 1L) {
                        throw StandardException.newException("XSLAC.D", this.dataDirectory);
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                if (this.writeControlFile(storageFile2, 0L)) {
                    StorageRandomAccessFile storageRandomAccessFile;
                    this.firstLogFileNumber = 1L;
                    this.logFileNumber = 1L;
                    storageFile = this.getLogFileName(this.logFileNumber);
                    if (this.privExists(storageFile)) {
                        Monitor.logTextMessage("L009", storageFile);
                        if (!this.privDelete(storageFile)) {
                            throw StandardException.newException("XSLAC.D", this.dataDirectory);
                        }
                    }
                    if (!this.initLogFile(storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rw"), this.logFileNumber, 0L)) {
                        throw StandardException.newException("XSLAQ.D", storageFile.getPath());
                    }
                    this.endPosition = storageRandomAccessFile.getFilePointer();
                    this.lastFlush = storageRandomAccessFile.getFilePointer();
                    if (this.isWriteSynced) {
                        this.preAllocateNewLogFile(storageRandomAccessFile);
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = this.privRandomAccessFile(storageFile, "rws");
                        storageRandomAccessFile.seek(this.endPosition);
                    }
                    this.logOut = new LogAccessFile(storageRandomAccessFile, this.logBufferSize);
                } else {
                    this.ReadOnlyDB = true;
                    this.logOut = null;
                }
                this.recoveryNeeded = false;
            } else {
                this.recoveryNeeded = true;
            }
        }
        catch (IOException iOException) {
            throw Monitor.exceptionStartingModule(iOException);
        }
    }

    private void getLogStorageFactory() throws StandardException {
        if (this.logDevice == null) {
            DataFactory dataFactory = (DataFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
            this.logStorageFactory = (WritableStorageFactory)dataFactory.getStorageFactory();
        } else {
            try {
                PersistentService persistentService = Monitor.getMonitor().getServiceType(this);
                this.logStorageFactory = (WritableStorageFactory)persistentService.getStorageFactoryInstance(false, this.logDevice, null, null);
            }
            catch (IOException iOException) {
                throw StandardException.newException("XSLAB.D", iOException, (Object)this.logDevice);
            }
        }
    }

    public void stop() {
        if (this.checkpointDaemon != null) {
            this.checkpointDaemon.unsubscribe(this.myClientNumber);
            this.checkpointDaemon.stop();
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.stopped = true;
            if (this.logOut != null) {
                try {
                    this.logOut.flushLogAccessFile();
                    this.logOut.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.logOut = null;
            }
        }
        if (!(this.corrupt != null || this.logArchived() || this.keepAllLogs || this.ReadOnlyDB)) {
            this.deleteObsoleteLogfiles();
        }
        if (this.logDevice != null) {
            this.logStorageFactory.shutdown();
        }
        this.logStorageFactory = null;
    }

    private void deleteObsoleteLogfiles() {
        StorageFile storageFile;
        long l = this.getFirstLogNeeded(this.currentCheckpoint);
        if (l == -1L) {
            return;
        }
        try {
            storageFile = this.getLogDirectory();
        }
        catch (StandardException standardException) {
            return;
        }
        String[] stringArray = this.privList(storageFile);
        if (stringArray != null) {
            StorageFile storageFile2 = null;
            int n = 0;
            while (n < stringArray.length) {
                long l2;
                if (!stringArray[n].startsWith("log") || !stringArray[n].endsWith(".dat") || (l2 = Long.parseLong(stringArray[n].substring(3, stringArray[n].length() - 4))) >= l || this.privDelete(storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[n]))) {
                    // empty if block
                }
                ++n;
            }
        }
    }

    public boolean serviceASAP() {
        return false;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public void getLogFactoryProperties(PersistentSet persistentSet) throws StandardException {
        String string;
        String string2;
        if (persistentSet == null) {
            string2 = PropertyUtil.getSystemProperty("derby.storage.logSwitchInterval");
            string = PropertyUtil.getSystemProperty("derby.storage.checkpointInterval");
        } else {
            string2 = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.logSwitchInterval");
            string = PropertyUtil.getServiceProperty(persistentSet, "derby.storage.checkpointInterval");
        }
        if (string2 != null) {
            this.logSwitchInterval = Integer.parseInt(string2);
            if (this.logSwitchInterval < 100000) {
                this.logSwitchInterval = 100000;
            } else if (this.logSwitchInterval > 0x8000000) {
                this.logSwitchInterval = 0x8000000;
            }
        }
        if (string != null) {
            this.checkpointInterval = Integer.parseInt(string);
            if (this.checkpointInterval < 100000) {
                this.checkpointInterval = 100000;
            } else if (this.checkpointInterval > 0x8000000) {
                this.checkpointInterval = 0x8000000;
            }
        }
    }

    public int performWork(ContextManager contextManager) {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.corrupt != null) {
                int n = 1;
                Object var3_4 = null;
                return n;
            }
        }
        AccessFactory accessFactory = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        try {
            if (accessFactory != null) {
                TransactionController transactionController = null;
                try {
                    transactionController = accessFactory.getAndNameTransaction(contextManager, "SystemTransaction");
                    this.getLogFactoryProperties(transactionController);
                }
                finally {
                    Object var8_9 = null;
                    if (transactionController != null) {
                        transactionController.commit();
                    }
                }
            }
            this.rawStoreFactory.checkpoint();
        }
        catch (StandardException standardException) {
            Monitor.logTextMessage("L011");
            this.logErrMsg(standardException);
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        this.checkpointDaemonCalled = false;
        return 1;
    }

    protected long appendLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        long l;
        boolean bl = false;
        if (this.ReadOnlyDB) {
            throw StandardException.newException("XSLAH.D");
        }
        if (n2 <= 0) {
            throw StandardException.newException("XSLB6.S");
        }
        try {
            LogToFile logToFile = this;
            synchronized (logToFile) {
                if (this.corrupt != null) {
                    throw StandardException.newException("XSLAA.D", this.corrupt);
                }
                if (this.logOut == null) {
                    throw StandardException.newException("XSLAJ.D");
                }
                if (this.endPosition + 16L + (long)n2 >= 0xFFFFFFFL) {
                    this.switchLogFile();
                    if (this.endPosition + 16L + (long)n2 >= 0xFFFFFFFL) {
                        throw StandardException.newException("XSLAL.D", new Long(this.logFileNumber), (Object)new Long(this.endPosition), (Object)new Long(n2), (Object)new Long(0xFFFFFFFL));
                    }
                }
                l = LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
                this.logOut.writeLogRecord(n2, l, byArray, n, byArray2, n3, n4);
                if (n4 != 0) {
                    // empty if block
                }
                this.endPosition += (long)(n2 + 16);
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA4.D", iOException));
        }
        return l;
    }

    protected synchronized long currentInstant() {
        return LogCounter.makeLogInstantAsLong(this.logFileNumber, this.endPosition);
    }

    protected synchronized long endPosition() {
        return this.endPosition;
    }

    private synchronized long getLogFileNumber() {
        return this.logFileNumber;
    }

    private synchronized long firstLogInstant() {
        return LogCounter.makeLogInstantAsLong(this.firstLogFileNumber, 24L);
    }

    /*
     * Exception decompiling
     */
    protected void flush(long var1_1, long var3_2) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 38[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void syncFile(StorageRandomAccessFile storageRandomAccessFile) throws StandardException {
        int n = 0;
        while (true) {
            try {
                storageRandomAccessFile.sync(false);
            }
            catch (IOException iOException) {
                ++n;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (n <= 20) continue;
                throw StandardException.newException("XSLA4.D", iOException, null);
            }
            break;
        }
    }

    public LogInstant setTruncationLWM(UUID uUID, LogInstant logInstant, RawStoreFactory rawStoreFactory, TransactionFactory transactionFactory) throws StandardException {
        Object object;
        this.checkCorrupt();
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (logInstant == null) {
                logInstant = new LogCounter(this.firstLogInstant());
            } else {
                long l = this.firstLogInstant();
                long l2 = ((LogCounter)logInstant).getValueAsLong();
                if (l2 < l || l2 > this.currentInstant()) {
                    throw StandardException.newException("XSLB5.S", uUID, (Object)logInstant, (Object)new LogCounter(l), (Object)new LogCounter(this.currentInstant()));
                }
            }
            this.setTruncationLWM(uUID, logInstant);
            this.movingTruncPt = true;
        }
        RawTransaction rawTransaction = null;
        try {
            object = new SaveLWMOperation(uUID, logInstant, true);
            rawTransaction = transactionFactory.startInternalTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager());
            rawTransaction.logAndDo((Loggable)object);
            rawTransaction.commit();
            LogToFile logToFile2 = this;
            synchronized (logToFile2) {
                this.flush(this.logFileNumber, this.endPosition);
            }
            rawTransaction.close();
            rawTransaction = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            LogToFile logToFile3 = this;
            synchronized (logToFile3) {
                this.movingTruncPt = false;
            }
            if (rawTransaction != null) {
                rawTransaction.abort();
                rawTransaction.close();
            }
            throw throwable;
        }
        Object var6_13 = null;
        object = this;
        synchronized (object) {
            this.movingTruncPt = false;
        }
        if (rawTransaction != null) {
            rawTransaction.abort();
            rawTransaction.close();
        }
        return logInstant;
    }

    public void setTruncationLWM(UUID uUID, LogInstant logInstant) throws StandardException {
        if (this.stopped) {
            throw StandardException.newException("XSLB9.S");
        }
        if (this.inRedo && (this.firstLogFileNumber < 0L || ((LogCounter)logInstant).getLogFileNumber() < this.firstLogFileNumber)) {
            this.firstLogFileNumber = ((LogCounter)logInstant).getLogFileNumber();
        }
        TruncationPoint truncationPoint = null;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.truncPoints == null) {
                this.truncPoints = new Vector(1, 1);
            } else {
                truncationPoint = this.findTruncPoint(uUID);
            }
            if (truncationPoint == null) {
                truncationPoint = new TruncationPoint(uUID, logInstant);
                this.truncPoints.addElement(truncationPoint);
            } else {
                truncationPoint.setLogInstant(logInstant);
            }
        }
    }

    public LogInstant getTruncationLWM(UUID uUID) {
        LogInstant logInstant = null;
        LogToFile logToFile = this;
        synchronized (logToFile) {
            TruncationPoint truncationPoint = this.findTruncPoint(uUID);
            if (truncationPoint != null) {
                logInstant = truncationPoint.getLogInstant();
            }
        }
        return logInstant;
    }

    public void removeTruncationLWM(UUID uUID, RawStoreFactory rawStoreFactory, TransactionFactory transactionFactory) throws StandardException {
        if (this.corrupt != null) {
            throw StandardException.newException("XSLAA.D", this.corrupt);
        }
        if (this.stopped) {
            throw StandardException.newException("XSLB9.S");
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.findTruncPoint(uUID) == null) {
                throw StandardException.newException("XSLB4.S");
            }
            this.removeTruncationLWM(uUID);
        }
        SaveLWMOperation saveLWMOperation = new SaveLWMOperation(uUID, null, false);
        RawTransaction rawTransaction = transactionFactory.startInternalTransaction(rawStoreFactory, ContextService.getFactory().getCurrentContextManager());
        try {
            rawTransaction.logAndDo(saveLWMOperation);
        }
        finally {
            Object var5_8 = null;
            rawTransaction.commit();
            rawTransaction.close();
        }
    }

    public void removeTruncationLWM(UUID uUID) throws StandardException {
        if (this.corrupt != null) {
            throw StandardException.newException("XSLAA.D", this.corrupt);
        }
        LogToFile logToFile = this;
        synchronized (logToFile) {
            TruncationPoint truncationPoint = this.findTruncPoint(uUID);
            if (truncationPoint != null) {
                this.truncPoints.removeElement(truncationPoint);
            }
        }
    }

    private TruncationPoint findTruncPoint(UUID uUID) {
        if (this.truncPoints == null) {
            return null;
        }
        int n = this.truncPoints.size() - 1;
        while (n >= 0) {
            TruncationPoint truncationPoint = (TruncationPoint)this.truncPoints.elementAt(n);
            if (truncationPoint.isEqual(uUID)) {
                return truncationPoint;
            }
            --n;
        }
        return null;
    }

    public LogScan openForwardsFlushedScan(LogInstant logInstant) throws StandardException {
        this.checkCorrupt();
        return new FlushedScan(this, ((LogCounter)logInstant).getValueAsLong());
    }

    public LogScan openForwardsScan(LogInstant logInstant, LogInstant logInstant2) throws StandardException {
        try {
            long l = logInstant == null ? 0L : ((LogCounter)logInstant).getValueAsLong();
            return this.openForwardsScan(l, logInstant2);
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
    }

    public final boolean databaseEncrypted() {
        return this.databaseEncrypted;
    }

    public int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.encrypt(byArray, n, n2, byArray2, n3);
    }

    public int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws StandardException {
        return this.rawStoreFactory.decrypt(byArray, n, n2, byArray2, n3);
    }

    public int getEncryptionBlockSize() {
        return this.rawStoreFactory.getEncryptionBlockSize();
    }

    public synchronized LogInstant getFirstUnflushedInstant() {
        return new LogCounter(this.logFileNumber, this.lastFlush);
    }

    private LogInstant restoreTruncationLWMs(TruncationPoint[] truncationPointArray) {
        if (this.truncPoints != null) {
            this.truncPoints.removeAllElements();
        }
        if (truncationPointArray == null || truncationPointArray.length == 0) {
            return null;
        }
        if (this.truncPoints == null) {
            this.truncPoints = new Vector(truncationPointArray.length, 1);
        }
        LogInstant logInstant = null;
        int n = 0;
        while (n < truncationPointArray.length) {
            TruncationPoint truncationPoint = truncationPointArray[n];
            this.truncPoints.addElement(truncationPoint);
            if (logInstant == null || truncationPoint.getLogInstant().lessThan(logInstant)) {
                logInstant = truncationPoint.getLogInstant();
            }
            ++n;
        }
        return logInstant;
    }

    public void freezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            if (this.logArchived) {
                this.switchLogFile();
            }
            this.isFrozen = true;
        }
    }

    public void unfreezePersistentStore() throws StandardException {
        LogToFile logToFile = this;
        synchronized (logToFile) {
            this.isFrozen = false;
            this.notifyAll();
        }
    }

    public boolean logArchived() {
        return this.logArchived;
    }

    protected void logErrMsg(String string) {
        Monitor.logTextMessage("L001");
        Monitor.logMessage(string);
        Monitor.logTextMessage("L002");
    }

    protected void logErrMsg(Throwable throwable) {
        if (this.corrupt != null) {
            Monitor.logTextMessage("L003");
            this.printErrorStack(this.corrupt);
            Monitor.logTextMessage("L004");
        }
        if (throwable != this.corrupt) {
            Monitor.logTextMessage("L005");
            this.printErrorStack(throwable);
            Monitor.logTextMessage("L006");
        }
    }

    private void printErrorStack(Throwable throwable) {
        Monitor.logMessage("-------------------------\n");
        throwable.printStackTrace(Monitor.getStream().getPrintWriter());
        Monitor.logMessage("-------------------------\n");
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(Monitor.getStream().getHeader());
        errorStringBuilder.stackTrace(throwable);
    }

    private long logtest_appendPartialLogRecord(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws StandardException {
        return 0L;
    }

    protected void testLogFull() throws IOException {
    }

    public void enableLogArchiveMode() throws StandardException {
        if (!this.logArchived) {
            this.logArchived = true;
            AccessFactory accessFactory = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
            if (accessFactory != null) {
                TransactionController transactionController = null;
                transactionController = accessFactory.getTransaction(ContextService.getFactory().getCurrentContextManager());
                transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"true"), true);
            }
        }
    }

    public void disableLogArchiveMode() throws StandardException {
        this.logArchived = false;
        AccessFactory accessFactory = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        if (accessFactory != null) {
            TransactionController transactionController = null;
            transactionController = accessFactory.getTransaction(ContextService.getFactory().getCurrentContextManager());
            transactionController.setProperty("derby.storage.logArchiveMode", (Serializable)((Object)"false"), true);
        }
    }

    public void deleteOnlineArchivedLogFiles() {
        this.deleteObsoleteLogfiles();
    }

    public synchronized boolean copyActiveLogFiles(File file) throws StandardException {
        long l = this.getFirstLogNeeded(this.currentCheckpoint);
        if (l == -1L) {
            return true;
        }
        StorageFile storageFile = this.getLogFileName(l);
        File file2 = null;
        long l2 = this.logArchived ? this.getLogFileNumber() - 1L : this.getLogFileNumber();
        while (l <= l2) {
            file2 = new File(file, storageFile.getName());
            if (!this.privCopyFile(storageFile, file2)) {
                return false;
            }
            storageFile = this.getLogFileName(++l);
        }
        storageFile = this.getControlFileName();
        if (!this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()))) {
            return false;
        }
        storageFile = this.getMirrorControlFileName();
        return this.privCopyFile(storageFile, file2 = new File(file, storageFile.getName()));
    }

    public boolean inRFR() {
        if (this.recoveryNeeded) {
            boolean bl = false;
            try {
                bl = !this.privCanWrite(this.getControlFileName());
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            bl = bl || (this.dataFactory == null ? false : this.dataFactory.isReadOnly());
            return !bl;
        }
        return false;
    }

    public void checkpointInRFR(LogInstant logInstant, long l, DataFactory dataFactory) throws StandardException {
        dataFactory.checkpoint();
        try {
            if (!this.writeControlFile(this.getControlFileName(), ((LogCounter)logInstant).getValueAsLong())) {
                throw StandardException.newException("XSLAE.D", this.getControlFileName());
            }
        }
        catch (IOException iOException) {
            throw this.markCorrupt(StandardException.newException("XSLA2.D", iOException));
        }
        dataFactory.removeDroppedContainerFileStubs(new LogCounter(l));
    }

    private void restoreLogs(Properties properties) throws StandardException {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        string = properties.getProperty("createFrom");
        if (string == null) {
            string = properties.getProperty("restoreFrom");
        } else {
            bl = true;
        }
        if (string == null) {
            string = properties.getProperty("rollForwardRecoveryFrom");
        } else {
            bl2 = true;
        }
        if (string != null) {
            if (!bl && this.logDevice == null) {
                this.logDevice = properties.getProperty("derby.storage.logDeviceWhenBackedUp");
            }
            this.getLogStorageFactory();
            StorageFile storageFile = this.logStorageFactory.newStorageFile("log");
            if (bl && this.privExists(storageFile)) {
                throw StandardException.newException("XSLAT.D", this.getLogDirPath(storageFile));
            }
            if (bl2 && this.logDevice != null && !this.privRemoveDirectory(storageFile) && !this.privDelete(storageFile)) {
                throw StandardException.newException("XSDG7.D", this.getLogDirPath(storageFile));
            }
            storageFile = this.getLogDirectory();
            File file = new File(string, "log");
            String[] stringArray = this.privList(file);
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file, stringArray[n]);
                    StorageFile storageFile2 = this.logStorageFactory.newStorageFile(storageFile, stringArray[n]);
                    if (!this.privCopyFile(file2, storageFile2)) {
                        throw StandardException.newException("XSLAR.D", file2, (Object)storageFile2);
                    }
                    ++n;
                }
            } else {
                throw StandardException.newException("XSLAS.D", file);
            }
            this.logSwitchRequired = true;
        }
    }

    private void preAllocateNewLogFile(StorageRandomAccessFile storageRandomAccessFile) throws IOException, StandardException {
        int n = this.logSwitchInterval - 24;
        int n2 = this.logBufferSize * 2;
        byte[] byArray = new byte[n2];
        int n3 = n / n2;
        int n4 = n % n2;
        try {
            while (n3-- > 0) {
                storageRandomAccessFile.write(byArray);
            }
            if (n4 != 0) {
                storageRandomAccessFile.write(byArray, 0, n4);
            }
            this.syncFile(storageRandomAccessFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StorageRandomAccessFile openLogFileInWriteMode(StorageFile storageFile) throws IOException {
        if (this.isWriteSynced) {
            return this.privRandomAccessFile(storageFile, "rws");
        }
        return this.privRandomAccessFile(storageFile, "rw");
    }

    private String getLogDirPath(StorageFile storageFile) {
        if (this.logDevice == null) {
            return storageFile.toString();
        }
        return this.logDevice + this.logStorageFactory.getSeparator() + storageFile.toString();
    }

    protected boolean privExists(StorageFile storageFile) {
        return this.runBooleanAction(0, storageFile);
    }

    protected boolean privDelete(StorageFile storageFile) {
        return this.runBooleanAction(1, storageFile);
    }

    protected synchronized StorageRandomAccessFile privRandomAccessFile(StorageFile storageFile, String string) throws IOException {
        this.action = 2;
        this.activeFile = storageFile;
        this.activePerms = string;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    protected boolean privCanWrite(StorageFile storageFile) {
        return this.runBooleanAction(3, storageFile);
    }

    protected boolean privMkdirs(StorageFile storageFile) {
        return this.runBooleanAction(4, storageFile);
    }

    protected synchronized String[] privList(File file) {
        this.action = 8;
        this.toFile = file;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    protected synchronized String[] privList(StorageFile storageFile) {
        this.action = 5;
        this.activeFile = storageFile;
        try {
            return (String[])AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    protected synchronized boolean privCopyFile(StorageFile storageFile, File file) {
        this.action = 6;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    protected synchronized boolean privCopyFile(File file, StorageFile storageFile) {
        this.action = 9;
        this.activeFile = storageFile;
        this.toFile = file;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    protected boolean privRemoveDirectory(StorageFile storageFile) {
        return this.runBooleanAction(7, storageFile);
    }

    private synchronized boolean runBooleanAction(int n, StorageFile storageFile) {
        this.action = n;
        this.activeFile = storageFile;
        try {
            return (Boolean)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    public Object run() throws IOException {
        switch (this.action) {
            case 0: {
                return ReuseFactory.getBoolean(this.activeFile.exists());
            }
            case 1: {
                return ReuseFactory.getBoolean(this.activeFile.delete());
            }
            case 2: {
                return this.activeFile.getRandomAccessFile(this.activePerms);
            }
            case 3: {
                return ReuseFactory.getBoolean(this.activeFile.canWrite());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.activeFile.mkdirs());
            }
            case 5: {
                return this.activeFile.list();
            }
            case 6: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)this.logStorageFactory, this.activeFile, this.toFile));
            }
            case 7: {
                if (!this.activeFile.exists()) {
                    return ReuseFactory.getBoolean(true);
                }
                return ReuseFactory.getBoolean(this.activeFile.deleteAll());
            }
            case 8: {
                return this.toFile.list();
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyFile(this.logStorageFactory, this.toFile, this.activeFile));
            }
        }
        return null;
    }

    public LogToFile() {
        this.keepAllLogs = PropertyUtil.getSystemBoolean("derby.storage.keepTransactionLog");
    }
}

