/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.EmbedConnection20;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbedPooledConnection;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.XAStatementControl;
import org.apache.derby.jdbc.XATransactionState;

final class EmbedXAConnection
extends EmbedPooledConnection
implements XAConnection,
XAResource {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 2003, 2004.";
    final ResourceAdapter ra;
    XAXactId currentXid;

    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this;
    }

    public final synchronized void start(Xid xid, int n) throws XAException {
        this.checkXAActive();
        if (this.currentXid != null) {
            throw new XAException(-6);
        }
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        switch (n) {
            case 0: {
                if (xATransactionState != null) {
                    throw new XAException(-8);
                }
                try {
                    if (this.realConnection == null) {
                        this.openRealConnection();
                        if (this.currentConnectionHandle != null) {
                            this.currentConnectionHandle.setState(true);
                            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
                        }
                    } else {
                        if (this.currentConnectionHandle != null && this.currentConnectionHandle.getAutoCommit()) {
                            this.currentConnectionHandle.rollback();
                        }
                        if (!this.realConnection.transactionIsIdle()) {
                            throw new XAException(-9);
                        }
                        if (this.currentConnectionHandle != null) {
                            this.currentConnectionHandle.setState(true);
                            this.realConnection.rollback();
                        } else {
                            this.resetRealConnection();
                        }
                    }
                    this.realConnection.setAutoCommit(false);
                    this.realConnection.setHoldability(2);
                    this.realConnection.getLanguageConnection().getTransactionExecute().createXATransactionFromLocalTransaction(xAXactId.getFormatId(), xAXactId.getGlobalTransactionId(), xAXactId.getBranchQualifier());
                }
                catch (StandardException standardException) {
                    throw EmbedXAConnection.wrapInXAException(standardException);
                }
                catch (SQLException sQLException) {
                    throw EmbedXAConnection.wrapInXAException(sQLException);
                }
                if (this.ra.addConnection(xAXactId, new XATransactionState(this.realConnection.getContextManager(), this.realConnection, this, xAXactId))) break;
                throw new XAException(-8);
            }
            case 0x200000: 
            case 0x8000000: {
                if (xATransactionState == null) {
                    throw new XAException(-4);
                }
                xATransactionState.start(this, n);
                if (xATransactionState.conn == this.realConnection) break;
                if (this.realConnection != null) {
                    if (!this.realConnection.transactionIsIdle()) {
                        throw new XAException(-9);
                    }
                    EmbedXAConnection.closeUnusedConnection(this.realConnection);
                }
                this.realConnection = xATransactionState.conn;
                if (this.currentConnectionHandle == null) break;
                try {
                    this.currentConnectionHandle.setState(false);
                    this.realConnection.setApplicationConnection(this.currentConnectionHandle);
                    break;
                }
                catch (SQLException sQLException) {
                    throw EmbedXAConnection.wrapInXAException(sQLException);
                }
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.currentXid = xAXactId;
    }

    public final synchronized void end(Xid xid, int n) throws XAException {
        XATransactionState xATransactionState;
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        boolean bl = false;
        if (this.currentXid != null) {
            if (!this.currentXid.equals(xAXactId)) {
                throw new XAException(-6);
            }
            bl = true;
        }
        if ((xATransactionState = this.getTransactionState(xAXactId)) == null) {
            throw new XAException(-4);
        }
        boolean bl2 = xATransactionState.end(this, n, bl);
        if (bl) {
            this.currentXid = null;
            this.realConnection = null;
        }
        if (bl2) {
            throw new XAException(xATransactionState.rollbackOnlyCode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized int prepare(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager != null) throw new XAException(-6);
            throw new XAException(-4);
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared) {
                throw new XAException(-6);
            }
            EmbedConnection20 embedConnection20 = xATransactionState.conn;
            try {
                int n = embedConnection20.xa_prepare();
                if (n == 2) {
                    xATransactionState.isPrepared = true;
                    return 0;
                }
                this.returnConnectionToResource(xATransactionState, xAXactId);
                return 3;
            }
            catch (SQLException sQLException) {
                throw EmbedXAConnection.wrapInXAException(sQLException);
            }
        }
    }

    public final synchronized void commit(Xid xid, boolean bl) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = ContextService.getFactory();
            contextService.setCurrentContextManager(contextManager);
            try {
                try {
                    xAResourceManager.commit(contextManager, xAXactId, bl);
                    contextManager.cleanupOnError(StandardException.closeException());
                    Object var9_10 = null;
                    contextService.resetCurrentContextManager(contextManager);
                    return;
                }
                catch (StandardException standardException) {
                    contextManager.cleanupOnError(standardException);
                    throw EmbedXAConnection.wrapInXAException(standardException);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                contextService.resetCurrentContextManager(contextManager);
                throw throwable;
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            this.checkUserCredentials(xATransactionState.creatingResource);
            switch (xATransactionState.associationState) {
                case 0: {
                    break;
                }
                case -1: {
                    throw new XAException(xATransactionState.rollbackOnlyCode);
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            if (xATransactionState.isPrepared == bl) {
                throw new XAException(-6);
            }
            EmbedConnection20 embedConnection20 = xATransactionState.conn;
            try {
                try {
                    embedConnection20.xa_commit(bl);
                }
                catch (SQLException sQLException) {
                    throw EmbedXAConnection.wrapInXAException(sQLException);
                }
                Object var9_12 = null;
                this.returnConnectionToResource(xATransactionState, xAXactId);
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.returnConnectionToResource(xATransactionState, xAXactId);
                throw throwable;
            }
        }
    }

    public final synchronized void rollback(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = ContextService.getFactory();
            contextService.setCurrentContextManager(contextManager);
            try {
                try {
                    xAResourceManager.rollback(contextManager, xAXactId);
                    contextManager.cleanupOnError(StandardException.closeException());
                    Object var8_9 = null;
                    contextService.resetCurrentContextManager(contextManager);
                    return;
                }
                catch (StandardException standardException) {
                    contextManager.cleanupOnError(standardException);
                    throw EmbedXAConnection.wrapInXAException(standardException);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                contextService.resetCurrentContextManager(contextManager);
                throw throwable;
            }
        }
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            switch (xATransactionState.associationState) {
                case -1: 
                case 0: {
                    break;
                }
                default: {
                    throw new XAException(-6);
                }
            }
            if (xATransactionState.suspendedList != null && xATransactionState.suspendedList.size() != 0) {
                throw new XAException(-6);
            }
            this.checkUserCredentials(xATransactionState.creatingResource);
            try {
                try {
                    xATransactionState.conn.xa_rollback();
                }
                catch (SQLException sQLException) {
                    throw EmbedXAConnection.wrapInXAException(sQLException);
                }
                Object var7_14 = null;
                this.returnConnectionToResource(xATransactionState, xAXactId);
            }
            catch (Throwable throwable) {
                Object var7_15 = null;
                this.returnConnectionToResource(xATransactionState, xAXactId);
                throw throwable;
            }
        }
    }

    public final synchronized Xid[] recover(int n) throws XAException {
        this.checkXAActive();
        try {
            return this.ra.getXAResourceManager().recover(n);
        }
        catch (StandardException standardException) {
            throw EmbedXAConnection.wrapInXAException(standardException);
        }
    }

    public final synchronized void forget(Xid xid) throws XAException {
        this.checkXAActive();
        XAXactId xAXactId = new XAXactId(xid);
        XATransactionState xATransactionState = this.getTransactionState(xAXactId);
        if (xATransactionState == null) {
            XAResourceManager xAResourceManager = this.ra.getXAResourceManager();
            ContextManager contextManager = xAResourceManager.find(xid);
            if (contextManager == null) {
                throw new XAException(-4);
            }
            ContextService contextService = ContextService.getFactory();
            contextService.setCurrentContextManager(contextManager);
            try {
                try {
                    xAResourceManager.forget(contextManager, xAXactId);
                    contextManager.cleanupOnError(StandardException.closeException());
                    Object var8_7 = null;
                    contextService.resetCurrentContextManager(contextManager);
                    return;
                }
                catch (StandardException standardException) {
                    contextManager.cleanupOnError(standardException);
                    throw EmbedXAConnection.wrapInXAException(standardException);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                contextService.resetCurrentContextManager(contextManager);
                throw throwable;
            }
        }
        throw new XAException(xATransactionState.isPrepared ? -4 : -6);
    }

    public final synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        this.checkXAActive();
        if (xAResource instanceof EmbedXAConnection) {
            return this.ra == ((EmbedXAConnection)xAResource).ra;
        }
        return false;
    }

    public int getTransactionTimeout() {
        return 0;
    }

    public boolean setTransactionTimeout(int n) {
        return false;
    }

    public void checkAutoCommit(boolean bl) throws SQLException {
        if (bl && this.currentXid != null) {
            throw Util.generateCsSQLException("XJ056.S");
        }
        super.checkAutoCommit(bl);
    }

    public void checkHoldCursors(int n) throws SQLException {
        if (n == 1 && this.currentXid != null) {
            throw Util.generateCsSQLException("XJ05C.S");
        }
        super.checkHoldCursors(n);
    }

    public void checkSavepoint() throws SQLException {
        if (this.currentXid != null) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkSavepoint();
    }

    public void checkRollback() throws SQLException {
        if (this.currentXid != null) {
            throw Util.generateCsSQLException("XJ058.S");
        }
        super.checkRollback();
    }

    public void checkCommit() throws SQLException {
        if (this.currentXid != null) {
            throw Util.generateCsSQLException("XJ057.S");
        }
        super.checkCommit();
    }

    public Connection getConnection() throws SQLException {
        Connection connection;
        if (this.currentXid == null) {
            connection = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw Util.generateCsSQLException("XJ059.S");
            }
            connection = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        return connection;
    }

    public Statement wrapStatement(Statement statement) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, statement);
        return xAStatementControl.applicationStatement;
    }

    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, preparedStatement, string, object);
        return (PreparedStatement)((Object)xAStatementControl.applicationStatement);
    }

    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, callableStatement, string);
        return (CallableStatement)((Object)xAStatementControl.applicationStatement);
    }

    public Connection getRealConnection() throws SQLException {
        Connection connection = super.getRealConnection();
        if (connection != null) {
            return connection;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }

    private XATransactionState getTransactionState(XAXactId xAXactId) {
        return (XATransactionState)this.ra.findConnection(xAXactId);
    }

    private static XAException wrapInXAException(SQLException sQLException) {
        String string = sQLException.getSQLState();
        String string2 = sQLException.getMessage();
        XAException xAException = string == null ? (string2 != null ? new XAException(string2) : new XAException(-3)) : (string.equals(StandardException.getSQLStateFromIdentifier("XSAX1.S")) ? new XAException(-8) : (string.equals(StandardException.getSQLStateFromIdentifier("XSAX0.S")) ? new XAException(105) : (string.equals("40001") ? new XAException(102) : (string.equals("40XL1") ? new XAException(106) : (string2 != null ? new XAException(string2) : new XAException(-3))))));
        if (JVMInfo.JDK_ID >= 4) {
            xAException.initCause(sQLException);
        }
        return xAException;
    }

    private static XAException wrapInXAException(StandardException standardException) {
        return EmbedXAConnection.wrapInXAException(TransactionResourceImpl.wrapInSQLException(null, standardException));
    }

    void removeXATransaction(XAXactId xAXactId) {
        XATransactionState xATransactionState = (XATransactionState)this.ra.removeConnection(xAXactId);
        if (xATransactionState != null) {
            xATransactionState.popMe();
        }
    }

    private void returnConnectionToResource(XATransactionState xATransactionState, XAXactId xAXactId) {
        this.removeXATransaction(xAXactId);
        XATransactionState xATransactionState2 = xATransactionState;
        synchronized (xATransactionState2) {
            xATransactionState.associationState = 3;
            xATransactionState.notifyAll();
            EmbedConnection20 embedConnection20 = xATransactionState.conn;
            if (xATransactionState.creatingResource.realConnection == embedConnection20 || xATransactionState.creatingResource.realConnection == null) {
                xATransactionState.creatingResource.realConnection = embedConnection20;
                BrokeredConnection brokeredConnection = xATransactionState.creatingResource.currentConnectionHandle;
                embedConnection20.setApplicationConnection(brokeredConnection);
                if (brokeredConnection != null) {
                    try {
                        brokeredConnection.setState(true);
                    }
                    catch (SQLException sQLException) {
                        EmbedXAConnection.closeUnusedConnection(xATransactionState.conn);
                        xATransactionState.creatingResource.realConnection = null;
                    }
                }
                Object var4_7 = null;
                return;
            }
        }
        EmbedXAConnection.closeUnusedConnection(xATransactionState.conn);
    }

    private void checkXAActive() throws XAException {
        try {
            this.checkActive();
        }
        catch (SQLException sQLException) {
            throw EmbedXAConnection.wrapInXAException(sQLException);
        }
    }

    private void checkUserCredentials(EmbedXAConnection embedXAConnection) throws XAException {
        if (embedXAConnection == this) {
            return;
        }
        if (embedXAConnection.getPassword().equals(this.getPassword()) && embedXAConnection.getUsername().equals(this.getUsername())) {
            return;
        }
        throw new XAException(103);
    }

    private static void closeUnusedConnection(EmbedConnection20 embedConnection20) {
        if (embedConnection20 != null) {
            try {
                embedConnection20.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    EmbedXAConnection(EmbeddedDataSource embeddedDataSource, ResourceAdapter resourceAdapter, String string, String string2, boolean bl) throws SQLException {
        super(embeddedDataSource, string, string2, bl);
        this.ra = resourceAdapter;
    }
}

