/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.tools.JDBCDisplayUtil;

public class util
implements PrivilegedAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static final Class[] STRING_P = new Class[]{"".getClass()};
    private static final Class[] INT_P = new Class[]{Integer.TYPE};
    private static final String[][] protocolDrivers = new String[][]{{"jdbc:derby:net:", "com.ibm.db2.jcc.DB2Driver"}, {"jdbc:derby:", "org.apache.derby.jdbc.EmbeddedDriver"}};
    private String key;
    private static /* synthetic */ Class class$Lorg$apache$derby$impl$tools$ij$util;

    public static String getArg(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) break;
            ++n;
        }
        if (n >= stringArray.length - 1) {
            return null;
        }
        return stringArray[n + 1];
    }

    public static boolean getPropertyArg(String[] stringArray) throws IOException {
        InputStream inputStream;
        String string = util.getArg("-p", stringArray);
        if (string != null) {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
        } else {
            string = util.getArg("-pr", stringArray);
            if (string != null) {
                inputStream = util.getResourceAsStream(string);
                if (inputStream == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return false;
            }
        }
        Properties properties = System.getProperties();
        util.loadWithTrimmedValues(inputStream, properties);
        return true;
    }

    public static Properties getConnAttributeArg(String[] stringArray) throws IOException {
        InputStream inputStream;
        Properties properties = new Properties();
        String string = util.getArg("-ca", stringArray);
        if (string != null) {
            inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream);
        } else {
            string = util.getArg("-car", stringArray);
            if (string != null) {
                inputStream = util.getResourceAsStream(string);
                if (inputStream == null) {
                    throw ijException.resourceNotFound();
                }
            } else {
                return null;
            }
        }
        util.loadWithTrimmedValues(inputStream, properties);
        return properties;
    }

    static String qualifyResourceName(String string, boolean bl) {
        if ((string = string.trim()).startsWith("/")) {
            return string;
        }
        String string2 = util.getSystemProperty("ij.defaultResourcePackage").trim();
        if (string2 == null) {
            return null;
        }
        string = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
        if (bl && !string.startsWith("/")) {
            return null;
        }
        return string;
    }

    public static InputStream getResourceAsStream(String string) {
        Class clazz = class$Lorg$apache$derby$impl$tools$ij$util != null ? class$Lorg$apache$derby$impl$tools$ij$util : (class$Lorg$apache$derby$impl$tools$ij$util = util.class$("org.apache.derby.impl.tools.ij.util"));
        if ((string = util.qualifyResourceName(string, true)) == null) {
            return null;
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream != null) {
            inputStream = new BufferedInputStream(inputStream, 2048);
        }
        return inputStream;
    }

    public static String getFileArg(String[] stringArray) throws IOException {
        boolean bl = false;
        if (stringArray == null) {
            return null;
        }
        String string = util.getArg("-f", stringArray);
        if (string != null) {
            return string;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-f") || stringArray[n].equals("-fr") || stringArray[n].equals("-ca") || stringArray[n].equals("-car") || stringArray[n].equals("-p") || stringArray[n].equals("-pr")) {
                ++n;
            } else {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public static String getInputResourceNameArg(String[] stringArray) {
        return util.getArg("-fr", stringArray);
    }

    public static boolean invalidArgs(String[] stringArray, boolean bl, String string, String string2) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (!bl3 && (stringArray[n].equals("-f") || stringArray[n].equals("-fr"))) {
                bl3 = true;
                if (++n >= stringArray.length) {
                    return true;
                }
            } else if (stringArray[n].equals("-p") || stringArray[n].equals("-pr") || stringArray[n].equals("-ca") || stringArray[n].equals("-car")) {
                if (++n >= stringArray.length) {
                    return true;
                }
            } else if (!bl3) {
                bl3 = true;
            } else {
                return true;
            }
            ++n;
        }
        return false;
    }

    static void Usage(LocalizedOutput localizedOutput) {
        localizedOutput.println(LocalizedResource.getMessage("IJ_UsageJavaComCloudToolsIjPPropeInput"));
        localizedOutput.flush();
    }

    public static void setupDataSource(Object object) throws Exception {
        Method[] methodArray = object.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            if (string.startsWith("set") && string.length() > "set".length()) {
                String string2 = string.substring("set".length());
                string2 = "ij.dataSource." + string2.substring(0, 1).toLowerCase(Locale.ENGLISH) + string2.substring(1);
                String string3 = util.getSystemProperty(string2);
                if (string3 != null) {
                    try {
                        method.invoke(object, string3);
                    }
                    catch (Throwable throwable) {
                        method.invoke(object, Integer.valueOf(string3));
                    }
                }
            }
            ++n;
        }
    }

    public static Connection startJBMS(String string, String string2, Properties properties) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string3;
        String string4;
        Connection connection = null;
        String string5 = util.getSystemProperty("driver");
        if (string5 == null) {
            string5 = util.getSystemProperty("ij.driver");
        }
        if (string5 == null || string5.length() == 0) {
            string5 = string;
        }
        if (string5 != null) {
            util.loadDriver(string5);
        }
        if ((string4 = util.getSystemProperty("ij.protocol")) != null) {
            util.loadDriverIfKnown(string4);
        }
        if ((string3 = util.getSystemProperty("database")) == null) {
            string3 = util.getSystemProperty("ij.database");
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        if (string3 != null) {
            String string6;
            boolean bl = false;
            try {
                if (string3.startsWith("jdbc:")) {
                    util.loadDriverIfKnown(string3);
                }
                DriverManager.getDriver(string3);
            }
            catch (SQLException sQLException) {
                bl = true;
            }
            if (bl && string4 != null) {
                string3 = string4 + string3;
            }
            String string7 = util.getSystemProperty("ij.user");
            String string8 = util.getSystemProperty("ij.password");
            properties = util.updateConnInfo(string7, string8, properties);
            String string9 = System.getProperty("driver");
            if (string9 == null) {
                string9 = "org.apache.derby.jdbc.EmbeddedDriver";
            }
            if ((string6 = System.getProperty("ij.dataSource")) == null) {
                util.loadDriver(string9);
                connection = DriverManager.getConnection(string3, properties);
                return connection;
            }
            Object var12_13 = null;
            try {
                Class<?> clazz = Class.forName(string6);
                var12_13 = clazz.newInstance();
                util.setupDataSource(var12_13);
                Method method = clazz.getMethod("getConnection", null);
                connection = (Connection)method.invoke(var12_13, new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
            }
            return connection;
        }
        return null;
    }

    public static Properties updateConnInfo(String string, String string2, Properties properties) {
        String string3 = util.getSystemProperty("framework");
        String string4 = util.getSystemProperty("ij.retrieveMessagesFromServerOnGetMessage");
        boolean bl = false;
        if (string3 != null && (string3.equals("DB2jNet") || string3.equals("DB2jcc"))) {
            bl = true;
        }
        if (string4 != null) {
            bl = !string4.equals("false");
        }
        if (properties == null) {
            properties = new Properties();
        }
        if (bl) {
            ((Hashtable)properties).put("retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (string != null) {
            ((Hashtable)properties).put("user", string);
        }
        if (string2 != null) {
            ((Hashtable)properties).put("password", string2);
        }
        return properties;
    }

    public static Connection startJBMS() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(null, null);
    }

    public static Connection startJBMS(String string, String string2) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return util.startJBMS(string, string2, null);
    }

    public static void DisplayVector(LocalizedOutput localizedOutput, Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            localizedOutput.println(vector.elementAt(n2));
            ++n2;
        }
    }

    public static void DisplayMulti(LocalizedOutput localizedOutput, PreparedStatement preparedStatement, ResultSet resultSet, Connection connection) throws SQLException, ijException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        bl3 = resultSet.next();
        while (!bl && bl3) {
            if (!bl2) {
                bl2 = true;
                if (connection.getAutoCommit()) {
                    localizedOutput.println(LocalizedResource.getMessage("IJ_IjWarniAutocMayCloseUsingResulSet"));
                    bl = true;
                }
            }
            int n2 = 1;
            while (n2 <= n) {
                preparedStatement.setObject(n2, resultSet.getObject(n2), resultSetMetaData.getColumnType(n2), resultSetMetaData.getScale(n2));
                ++n2;
            }
            bl3 = resultSet.next();
            if (!bl3 || connection.getAutoCommit()) {
                resultSet.close();
            }
            preparedStatement.execute();
            JDBCDisplayUtil.DisplayResults((PrintWriter)localizedOutput, (Statement)preparedStatement, connection);
            preparedStatement.clearParameters();
        }
        if (!bl2) {
            resultSet.close();
            throw ijException.noUsingResults();
        }
    }

    public static final String getSystemProperty(String string) {
        try {
            if (string.startsWith("ij.") || string.startsWith("derby.")) {
                util util2 = new util();
                util2.key = string;
                return (String)AccessController.doPrivileged(util2);
            }
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public final Object run() {
        return System.getProperty(this.key);
    }

    private static void loadWithTrimmedValues(InputStream inputStream, Properties properties) throws IOException {
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            string2 = string2.trim();
            ((Hashtable)properties).put(string, string2);
        }
    }

    public static void loadDriverIfKnown(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        int n = 0;
        while (n < protocolDrivers.length) {
            if (string.startsWith(protocolDrivers[n][0])) {
                util.loadDriver(protocolDrivers[n][1]);
                break;
            }
            ++n;
        }
    }

    public static void loadDriver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(string).newInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private util() {
    }
}

