/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;

public class JDBCDisplayUtil {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1998, 2004.";
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    public static boolean showSelectCount = false;
    private static final int MAX_RETRIES = 0;

    public static boolean init() {
        return LocalizedResource.getInstance() != null;
    }

    public static boolean init(String string) {
        return JDBCDisplayUtil.init(string, null);
    }

    public static boolean init(String string, String string2) {
        LocalizedResource.getInstance().init(string, string2, null);
        return true;
    }

    public static void ShowException(PrintWriter printWriter, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printWriter);
        }
    }

    public static void ShowSQLException(PrintWriter printWriter, SQLException sQLException) {
        String string = Boolean.getBoolean("ij.showErrorCode") ? LocalizedResource.getMessage("UT_Error0", LocalizedResource.getNumber(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            String string2 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst"));
            String string3 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), LocalizedResource.getMessage("UT_NoMessa"));
            printWriter.println(LocalizedResource.getMessage("UT_Error012", string2, string3, string));
            JDBCDisplayUtil.doTrace(printWriter, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            String string = JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst_7"));
            String string2 = JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), LocalizedResource.getMessage("UT_NoMessa_8"));
            printWriter.println(LocalizedResource.getMessage("UT_Warni01", string, string2));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void DisplayResults(PrintWriter printWriter, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, statement, connection, 0);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, Statement statement, Connection connection, int n) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, n);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printWriter, statement.getUpdateCount(), n);
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, statement);
    }

    static void DisplayUpdateCount(PrintWriter printWriter, int n, int n2) {
        if (n == 1) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_1RowInserUpdatDelet"));
        } else if (n >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_0RowsInserUpdatDelet", LocalizedResource.getNumber(n)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_StateExecu"));
        }
    }

    public static void DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, 0);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = 0;
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n);
        boolean bl = true;
        int n4 = 0;
        while (bl) {
            try {
                bl = resultSet.next();
                if (!bl) continue;
                JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n);
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
                ++n2;
            }
            catch (SQLException sQLException) {
                if (++n4 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
            }
        }
        if (showSelectCount) {
            if (n2 == 1) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_1RowSelec"));
            } else if (n2 >= 0) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_0RowsSelec", LocalizedResource.getNumber(n2)));
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    private static void DisplayNestedResults(PrintWriter printWriter, Vector vector, Connection connection, int n) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = LocalizedResource.getMessage("UT_JDBCDisplayUtil_16");
        String string2 = "0";
        int n2 = 0;
        while (n2 < vector.size()) {
            LocalizedResource.OutputWriter().println();
            String string3 = Integer.toString(n2);
            if (string3.length() > string2.length()) {
                string2 = string3;
                string = string + LocalizedResource.getMessage("UT_JDBCDisplayUtil_17");
            }
            LocalizedResource.OutputWriter().println(string);
            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("UT_Resul0", LocalizedResource.getNumber(n2)));
            LocalizedResource.OutputWriter().println(string);
            JDBCDisplayUtil.indent_DisplayResults(printWriter, (ResultSet)vector.elementAt(n2), connection, n);
            ++n2;
        }
    }

    public static void DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printWriter, resultSet, connection, 0);
    }

    private static void indent_DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n) throws SQLException {
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n2 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n);
            JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n2, vector, connection, n);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printWriter, resultSet, connection, 0);
    }

    private static void indent_DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n, LocalizedResource.getMessage("UT_NoCurreRow_19"));
            return;
        }
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n);
        JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n2, vector, connection, n);
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n);
        vector = null;
    }

    public static int DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, 0);
    }

    private static int indent_DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = resultSetMetaData.getColumnCount();
        int n3 = n2 - 1;
        int n4 = 1;
        while (n4 <= n2) {
            n3 += Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, LocalizedResource.getInstance().getColumnDisplaySize(resultSetMetaData, n4)));
            ++n4;
        }
        stringBuffer.ensureCapacity(n3);
        n4 = 1;
        while (n4 <= n2) {
            if (n4 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n4);
            int n5 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, LocalizedResource.getInstance().getColumnDisplaySize(resultSetMetaData, n4)));
            if (string.length() < n5) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n5);
                int n6 = stringBuffer2.length() + 64;
                while (n6 <= n5) {
                    stringBuffer2.append("                                                                ");
                    n6 += 64;
                }
                n6 = stringBuffer2.length() + 16;
                while (n6 <= n5) {
                    stringBuffer2.append("                ");
                    n6 += 16;
                }
                n6 = stringBuffer2.length() + 4;
                while (n6 <= n5) {
                    stringBuffer2.append("    ");
                    n6 += 4;
                }
                n6 = stringBuffer2.length();
                while (n6 < n5) {
                    stringBuffer2.append(' ');
                    ++n6;
                }
                stringBuffer.append((Object)stringBuffer2);
            } else if (string.length() > n5) {
                if (n5 > 1) {
                    stringBuffer.append(string.substring(0, n5 - 1));
                }
                if (n5 > 0) {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(string);
            }
            ++n4;
        }
        stringBuffer.setLength(Math.min(n3, 1024));
        JDBCDisplayUtil.indentedPrintLine(printWriter, n, stringBuffer);
        n4 = 0;
        while (n4 < Math.min(n3, 1024)) {
            stringBuffer.setCharAt(n4, '-');
            ++n4;
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n, stringBuffer);
        stringBuffer = null;
        return n3;
    }

    private static void DisplayRow(PrintWriter printWriter, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n, Vector vector, Connection connection, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 1;
        while (n4 <= n3) {
            String string;
            if (n4 > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n4)) {
                default: {
                    string = LocalizedResource.getInstance().getLocalizedString(resultSet, resultSetMetaData, n4);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object = resultSet.getObject(n4);
                    if (object == null) {
                        string = "NULL";
                        break;
                    }
                    if (object instanceof ResultSet && vector != null) {
                        string = LocalizedResource.getMessage("UT_Resul0_20", LocalizedResource.getNumber(vector.size()));
                        vector.addElement(object);
                        break;
                    }
                    try {
                        string = resultSet.getString(n4);
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n5 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, LocalizedResource.getInstance().getColumnDisplaySize(resultSetMetaData, n4)));
            if (string.length() < n5) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n5);
                int n6 = string.length();
                while (n6 < n5) {
                    stringBuffer2.append(' ');
                    ++n6;
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n5) {
                string = string.substring(0, n5 - 1) + "&";
            }
            stringBuffer.append(string);
            ++n4;
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw ijException.objectWasNull(string);
        }
    }

    public static String mapNull(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static void doTrace(PrintWriter printWriter, Exception exception) {
        if (Boolean.getBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    public static void setMaxDisplayWidth(int n) {
        maxWidth = n;
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n, String string) {
        JDBCDisplayUtil.indent(printWriter, n);
        printWriter.println(string);
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printWriter, n);
        printWriter.println(stringBuffer);
    }

    private static void indent(PrintWriter printWriter, int n) {
        int n2 = 0;
        while (n2 < n) {
            printWriter.print("  ");
            ++n2;
        }
    }

    public static void ShowException(PrintStream printStream, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printStream);
        }
    }

    public static void ShowSQLException(PrintStream printStream, SQLException sQLException) {
        String string = Boolean.getBoolean("ij.showErrorCode") ? " (errorCode = " + sQLException.getErrorCode() + ")" : "";
        while (sQLException != null) {
            printStream.println("ERROR " + JDBCDisplayUtil.mapNull(sQLException.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLException.getMessage(), "(no message)") + string);
            JDBCDisplayUtil.doTrace(printStream, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream printStream, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            printStream.println("WARNING " + JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), "(no message)"));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream printStream, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void DisplayResults(PrintStream printStream, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, statement, connection, 0);
    }

    private static void indent_DisplayResults(PrintStream printStream, Statement statement, Connection connection, int n) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, n);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printStream, statement.getUpdateCount(), n);
        }
        JDBCDisplayUtil.ShowWarnings(printStream, statement);
    }

    static void DisplayUpdateCount(PrintStream printStream, int n, int n2) {
        if (n == 1) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "1 row inserted/updated/deleted");
        } else if (n >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, n + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, 0);
    }

    private static void indent_DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = 0;
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n);
        boolean bl = true;
        int n4 = 0;
        while (bl) {
            try {
                bl = resultSet.next();
                if (!bl) continue;
                JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n);
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
                ++n2;
            }
            catch (SQLException sQLException) {
                if (++n4 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
            }
        }
        if (showSelectCount) {
            if (n2 == 1) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n, "1 row selected");
            } else if (n2 >= 0) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n, n2 + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    private static void DisplayNestedResults(PrintStream printStream, Vector vector, Connection connection, int n) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = "+ ResultSet #";
        String string2 = "++++++++++++++++";
        String string3 = "0";
        int n2 = 0;
        while (n2 < vector.size()) {
            System.out.println();
            String string4 = Integer.toString(n2);
            if (string4.length() > string3.length()) {
                string3 = string4;
                string2 = string2 + "+";
            }
            System.out.println(string2);
            System.out.println(string + n2 + " +");
            System.out.println(string2);
            JDBCDisplayUtil.indent_DisplayResults(printStream, (ResultSet)vector.elementAt(n2), connection, n);
            ++n2;
        }
    }

    public static void DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printStream, resultSet, connection, 0);
    }

    private static void indent_DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n) throws SQLException {
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n2 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n);
            JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n2, vector, connection, n);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n, LocalizedResource.getMessage("UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printStream, resultSet, connection, 0);
    }

    private static void indent_DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n, LocalizedResource.getMessage("UT_NoCurreRow_19"));
            return;
        }
        Vector vector = !connection.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n2 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n);
        JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n2, vector, connection, n);
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n);
        vector = null;
    }

    public static int DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, 0);
    }

    private static int indent_DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = resultSetMetaData.getColumnCount();
        int n3 = n2 - 1;
        int n4 = 1;
        while (n4 <= n2) {
            n3 += Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n4)));
            ++n4;
        }
        stringBuffer.ensureCapacity(n3);
        n4 = 1;
        while (n4 <= n2) {
            if (n4 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n4);
            int n5 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n4)));
            if (string.length() < n5) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n5);
                int n6 = stringBuffer2.length() + 64;
                while (n6 <= n5) {
                    stringBuffer2.append("                                                                ");
                    n6 += 64;
                }
                n6 = stringBuffer2.length() + 16;
                while (n6 <= n5) {
                    stringBuffer2.append("                ");
                    n6 += 16;
                }
                n6 = stringBuffer2.length() + 4;
                while (n6 <= n5) {
                    stringBuffer2.append("    ");
                    n6 += 4;
                }
                n6 = stringBuffer2.length();
                while (n6 < n5) {
                    stringBuffer2.append(' ');
                    ++n6;
                }
                stringBuffer.append((Object)stringBuffer2);
            } else if (string.length() > n5) {
                if (n5 > 1) {
                    stringBuffer.append(string.substring(0, n5 - 1));
                }
                if (n5 > 0) {
                    stringBuffer.append('&');
                }
            } else {
                stringBuffer.append(string);
            }
            ++n4;
        }
        stringBuffer.setLength(Math.min(n3, 1024));
        JDBCDisplayUtil.indentedPrintLine(printStream, n, stringBuffer);
        n4 = 0;
        while (n4 < Math.min(n3, 1024)) {
            stringBuffer.setCharAt(n4, '-');
            ++n4;
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n, stringBuffer);
        stringBuffer = null;
        return n3;
    }

    private static void DisplayRow(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n, Vector vector, Connection connection, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n);
        int n3 = resultSetMetaData.getColumnCount();
        int n4 = 1;
        while (n4 <= n3) {
            String string;
            if (n4 > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n4)) {
                default: {
                    string = resultSet.getString(n4);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object = resultSet.getObject(n4);
                    if (object == null) {
                        string = "NULL";
                        break;
                    }
                    if (object instanceof ResultSet && vector != null) {
                        string = "ResultSet #" + vector.size();
                        vector.addElement(object);
                        break;
                    }
                    try {
                        string = resultSet.getString(n4);
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n5 = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n4) == 0 ? 0 : 4, resultSetMetaData.getColumnDisplaySize(n4)));
            if (string.length() < n5) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n5);
                int n6 = string.length();
                while (n6 < n5) {
                    stringBuffer2.append(' ');
                    ++n6;
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n5) {
                string = string.substring(0, n5 - 1) + "&";
            }
            stringBuffer.append(string);
            ++n4;
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
    }

    public static void doTrace(PrintStream printStream, Exception exception) {
        if (Boolean.getBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printStream);
            printStream.flush();
        }
    }

    private static void indentedPrintLine(PrintStream printStream, int n, String string) {
        JDBCDisplayUtil.indent(printStream, n);
        printStream.println(string);
    }

    private static void indentedPrintLine(PrintStream printStream, int n, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printStream, n);
        printStream.println(stringBuffer);
    }

    private static void indent(PrintStream printStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            printStream.print("  ");
            ++n2;
        }
    }

    static {
        LocalizedResource.getInstance();
    }
}

