/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ConnectionEnv;
import org.apache.derby.impl.tools.ij.ParseException;
import org.apache.derby.impl.tools.ij.StatementFinder;
import org.apache.derby.impl.tools.ij.TokenMgrError;
import org.apache.derby.impl.tools.ij.UCode_CharStream;
import org.apache.derby.impl.tools.ij.ij;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijFatalException;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijRowResult;
import org.apache.derby.impl.tools.ij.ijTokenException;
import org.apache.derby.impl.tools.ij.ijTokenManager;
import org.apache.derby.impl.tools.ij.util;
import org.apache.derby.tools.JDBCDisplayUtil;

public class utilMain
implements PrivilegedAction {
    public static final String copyrightNotice = "(C) Copyright IBM Corp. 1997, 2004.";
    private static Class[] CONN_PARAM = new Class[]{Integer.TYPE};
    private static Object[] CONN_ARG = new Object[]{new Integer(2)};
    public static final int BUFFEREDFILESIZE = 2048;
    StatementFinder[] commandGrabber;
    UCode_CharStream charStream;
    ijTokenManager ijTokMgr;
    ij ijParser;
    ConnectionEnv[] connEnv;
    int currCE;
    private int numConnections;
    private boolean fileInput;
    private boolean initialFileInput;
    private boolean mtUse;
    private boolean firstRun = true;
    private LocalizedOutput out = null;
    private Properties connAttributeDefaults;
    private Hashtable ignoreErrors;
    protected boolean isJCC;
    Stack oldGrabbers = new Stack();
    LocalizedResource langUtil = LocalizedResource.getInstance();

    public void go(LocalizedInput[] localizedInputArray, LocalizedOutput localizedOutput, Properties properties) throws ijFatalException {
        ijResult ijResult2;
        boolean bl = false;
        String string = null;
        this.out = localizedOutput;
        this.connAttributeDefaults = properties;
        this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
        this.initialFileInput = !localizedInputArray[this.currCE].isStandardInput();
        this.fileInput = this.initialFileInput;
        int n = 0;
        while (n < this.commandGrabber.length) {
            this.commandGrabber[n].ReInit(localizedInputArray[n]);
            ++n;
        }
        if (this.firstRun) {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(this);
            ProductVersionHolder productVersionHolder = ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
            String string2 = productVersionHolder != null ? "" + productVersionHolder.getMajorVersion() + "." + productVersionHolder.getMinorVersion() : "?";
            localizedOutput.println(this.langUtil.getTextMessage("IJ_IjVers30C199", string2));
            int n2 = this.connEnv.length - 1;
            while (n2 >= 0) {
                Connection connection = this.connEnv[n2].getConnection();
                if (connection != null) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, connection);
                }
                --n2;
            }
            this.firstRun = false;
            n2 = Boolean.getBoolean("ij.showNoCountForSelect") ? 1 : 0;
            JDBCDisplayUtil.showSelectCount = n2 == 0;
            boolean bl2 = Boolean.getBoolean("ij.showNoConnectionsAtStart");
            if (!bl2) {
                try {
                    ijResult2 = this.ijParser.showConnectionsMethod(true);
                    this.displayResult(localizedOutput, ijResult2, this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    this.handleSQLException(localizedOutput, sQLException);
                }
            }
        }
        while (!this.ijParser.exit && !bl) {
            try {
                this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connEnv[this.currCE].doPrompt(true, localizedOutput);
            try {
                string = null;
                localizedOutput.flush();
                string = this.commandGrabber[this.currCE].nextStatement();
                while (string == null && !this.oldGrabbers.empty()) {
                    if (this.fileInput) {
                        this.commandGrabber[this.currCE].close();
                    }
                    this.commandGrabber[this.currCE] = (StatementFinder)this.oldGrabbers.pop();
                    if (this.oldGrabbers.empty()) {
                        this.fileInput = this.initialFileInput;
                    }
                    string = this.commandGrabber[this.currCE].nextStatement();
                }
                if (string == null && this.oldGrabbers.empty()) {
                    bl = true;
                } else {
                    boolean bl3 = this.ijParser.getElapsedTimeState();
                    long l = 0L;
                    if (this.fileInput) {
                        localizedOutput.println(string + ";");
                        localizedOutput.flush();
                    }
                    this.charStream.ReInit(new StringReader(string), 1, 1);
                    this.ijTokMgr.ReInit(this.charStream);
                    this.ijParser.ReInit(this.ijTokMgr);
                    if (bl3) {
                        l = System.currentTimeMillis();
                    }
                    ijResult2 = this.ijParser.ijStatement();
                    this.displayResult(localizedOutput, ijResult2, this.connEnv[this.currCE].getConnection());
                    if (bl3) {
                        long l2 = System.currentTimeMillis();
                        localizedOutput.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil", this.langUtil.getNumberAsString(l2 - l)));
                    }
                }
            }
            catch (ParseException parseException) {
                if (string != null) {
                    this.doCatch(string);
                }
            }
            catch (TokenMgrError tokenMgrError) {
                if (string != null) {
                    this.doCatch(string);
                }
            }
            catch (SQLException sQLException) {
                this.handleSQLException(localizedOutput, sQLException);
            }
            catch (ijException ijException2) {
                localizedOutput.println(this.langUtil.getTextMessage("IJ_IjErro0", ijException2.getMessage()));
                this.doTrace(ijException2);
            }
            catch (Throwable throwable) {
                localizedOutput.println(this.langUtil.getTextMessage("IJ_JavaErro0", throwable.toString()));
                this.doTrace(throwable);
            }
            ++this.currCE;
            this.currCE %= this.connEnv.length;
        }
        try {
            int n3 = 0;
            while (n3 < this.connEnv.length) {
                this.connEnv[n3].removeAllSessions();
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLException(localizedOutput, sQLException);
        }
        int n4 = 0;
        while (n4 < this.numConnections) {
            try {
                if (!localizedInputArray[n4].isStandardInput()) {
                    localizedInputArray[n4].close();
                }
            }
            catch (Exception exception) {
                localizedOutput.println(this.langUtil.getTextMessage("IJ_CannotCloseInFile", exception.toString()));
            }
            ++n4;
        }
        if (this.ijParser.exit || this.initialFileInput && !this.mtUse) {
            Driver driver = null;
            try {
                driver = DriverManager.getDriver("jdbc:derby:");
            }
            catch (Exception exception) {
                driver = null;
            }
            if (driver != null) {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void displayResult(LocalizedOutput localizedOutput, ijResult ijResult2, Connection connection) throws SQLException {
        if (ijResult2 != null) {
            if (ijResult2.isConnection()) {
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isStatement()) {
                Statement statement = ijResult2.getStatement();
                try {
                    JDBCDisplayUtil.DisplayResults((PrintWriter)localizedOutput, statement, this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
                ijResult2.closeStatement();
            } else if (ijResult2.isNextRowOfResultSet()) {
                ResultSet resultSet = ijResult2.getNextRowOfResultSet();
                JDBCDisplayUtil.DisplayCurrentRow(localizedOutput, resultSet, this.connEnv[this.currCE].getConnection());
            } else if (ijResult2.isVector()) {
                util.DisplayVector(localizedOutput, ijResult2.getVector());
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isMulti()) {
                try {
                    util.DisplayMulti(localizedOutput, (PreparedStatement)ijResult2.getStatement(), ijResult2.getResultSet(), this.connEnv[this.currCE].getConnection());
                }
                catch (SQLException sQLException) {
                    ijResult2.closeStatement();
                    throw sQLException;
                }
                ijResult2.closeStatement();
                if (ijResult2.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)localizedOutput, ijResult2.getSQLWarnings());
                    ijResult2.clearSQLWarnings();
                }
            } else if (ijResult2.isException()) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)ijResult2.getException());
            }
        }
    }

    private void doCatch(String string) {
        try {
            boolean bl = this.ijParser.getElapsedTimeState();
            long l = 0L;
            if (bl) {
                l = System.currentTimeMillis();
            }
            ijResult ijResult2 = this.ijParser.executeImmediate(string);
            this.displayResult(this.out, ijResult2, this.connEnv[this.currCE].getConnection());
            if (bl) {
                long l2 = System.currentTimeMillis();
                this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil_4", this.langUtil.getNumberAsString(l2 - l)));
            }
        }
        catch (SQLException sQLException) {
            this.handleSQLException(this.out, sQLException);
        }
        catch (ijException ijException2) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_5", ijException2.getMessage()));
            this.doTrace(ijException2);
        }
        catch (ijTokenException ijTokenException2) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_6", ijTokenException2.getMessage()));
            this.doTrace(ijTokenException2);
        }
        catch (Throwable throwable) {
            this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0_7", throwable.toString()));
            this.doTrace(throwable);
        }
    }

    public void handleSQLException(LocalizedOutput localizedOutput, SQLException sQLException) throws ijFatalException {
        String string = null;
        SQLException sQLException2 = null;
        String string2 = Boolean.getBoolean("ij.showErrorCode") ? this.langUtil.getTextMessage("IJ_Erro0", this.langUtil.getNumberAsString(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            block6: {
                block5: {
                    if (this.ignoreErrors == null) break block5;
                    string = sQLException.getSQLState();
                    if (string != null && this.ignoreErrors.get(string) != null) break block6;
                    sQLException2 = sQLException;
                }
                String string3 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), this.langUtil.getTextMessage("IJ_NoSqls"));
                String string4 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), this.langUtil.getTextMessage("IJ_NoMess"));
                localizedOutput.println(this.langUtil.getTextMessage("IJ_Erro012", string3, string4, string2));
                JDBCDisplayUtil.doTrace(localizedOutput, (Exception)sQLException);
            }
            sQLException = sQLException.getNextException();
        }
        if (sQLException2 != null) {
            throw new ijFatalException(sQLException2);
        }
    }

    private void doTrace(Throwable throwable) {
        if (util.getSystemProperty("ij.exceptionTrace") != null) {
            throwable.printStackTrace(this.out);
        }
        this.out.flush();
    }

    void newInput(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ijException.fileNotFound();
        }
        if (fileInputStream == null) {
            return;
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewInput(new BufferedInputStream(fileInputStream, 2048)));
        this.fileInput = true;
    }

    void newResourceInput(String string) {
        InputStream inputStream = util.getResourceAsStream(string);
        if (inputStream == null) {
            throw ijException.resourceNotFound();
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewInput(new BufferedInputStream(inputStream, 2048)));
        this.fileInput = true;
    }

    static void doPrompt(boolean bl, LocalizedOutput localizedOutput, String string) {
        if (bl) {
            localizedOutput.print("ij" + (string == null ? "" : string) + "> ");
        } else {
            localizedOutput.print("> ");
        }
        localizedOutput.flush();
    }

    void setMtUse(boolean bl) {
        this.mtUse = bl;
    }

    public utilMain getUtilMain() {
        return this;
    }

    public Connection setHoldability(Connection connection, int n) throws SQLException {
        try {
            Method method = connection.getClass().getMethod("setHoldability", CONN_PARAM);
            method.invoke((Object)connection, CONN_ARG);
        }
        catch (Exception exception) {
            throw PublicAPI.wrapStandardException(StandardException.plainWrapException(exception));
        }
        return connection;
    }

    public int getHoldability(Connection connection) throws SQLException {
        int n = 1;
        try {
            Method method = connection.getClass().getMethod("getHoldability", null);
            n = (Integer)method.invoke((Object)connection, null);
        }
        catch (Exception exception) {
            throw PublicAPI.wrapStandardException(StandardException.plainWrapException(exception));
        }
        return n;
    }

    public Statement createStatement(Connection connection, int n, int n2) throws SQLException {
        Statement statement;
        if (n2 != this.getHoldability(connection)) {
            throw ijException.holdCursorsNotSupported();
        }
        try {
            statement = connection.createStatement(n, 1007);
        }
        catch (AbstractMethodError abstractMethodError) {
            statement = connection.createStatement();
        }
        return statement;
    }

    public ijResult absolute(ResultSet resultSet, int n) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("ABSOLUTE");
        }
        if (n == 0) {
            throw ijException.zeroInvalidForAbsolute();
        }
        return new ijRowResult(resultSet, resultSet.absolute(n));
    }

    public ijResult relative(ResultSet resultSet, int n) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("RELATIVE");
        }
        return new ijRowResult(resultSet, resultSet.relative(n));
    }

    public ijResult beforeFirst(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("BEFORE FIRST");
        }
        resultSet.beforeFirst();
        return new ijRowResult(resultSet, false);
    }

    public ijResult first(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("FIRST");
        }
        return new ijRowResult(resultSet, resultSet.first());
    }

    public ijResult afterLast(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("AFTER LAST");
        }
        resultSet.afterLast();
        return new ijRowResult(resultSet, false);
    }

    public ijResult last(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("LAST");
        }
        return new ijRowResult(resultSet, resultSet.last());
    }

    public ijResult previous(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("PREVIOUS");
        }
        return new ijRowResult(resultSet, resultSet.previous());
    }

    public int getCurrentRowNumber(ResultSet resultSet) throws SQLException {
        boolean bl;
        try {
            bl = resultSet.getStatement().getResultSetType() == 1003;
        }
        catch (AbstractMethodError abstractMethodError) {
            bl = true;
        }
        if (bl) {
            throw ijException.forwardOnlyCursor("GETCURRENTROWNUMBER");
        }
        return resultSet.getRow();
    }

    public Properties getConnAttributeDefaults() {
        return this.connAttributeDefaults;
    }

    public final Object run() {
        return this.getClass().getResourceAsStream("/org/apache/derby/info/tools.properties");
    }

    public utilMain(int n, LocalizedOutput localizedOutput) throws ijFatalException {
        this(n, localizedOutput, null);
    }

    public utilMain(int n, LocalizedOutput localizedOutput, Hashtable hashtable) throws ijFatalException {
        String string = util.getSystemProperty("framework");
        if (string != null && (string.equals("DB2jNet") || string.equals("DB2jcc"))) {
            this.isJCC = true;
        }
        this.charStream = new UCode_CharStream(new StringReader(" "), 1, 1);
        this.ijTokMgr = new ijTokenManager(this.charStream);
        this.ijParser = new ij(this.ijTokMgr, this.getUtilMain());
        this.out = localizedOutput;
        this.ignoreErrors = hashtable;
        this.numConnections = n;
        this.commandGrabber = new StatementFinder[n];
        this.connEnv = new ConnectionEnv[n];
        int n2 = 0;
        while (n2 < n) {
            this.commandGrabber[n2] = new StatementFinder(this.langUtil.getNewInput(System.in));
            this.connEnv[n2] = new ConnectionEnv(n2, n > 1, n == 1);
            try {
                this.connEnv[n2].init(localizedOutput);
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)sQLException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                JDBCDisplayUtil.ShowException(localizedOutput, (Throwable)illegalAccessException);
            }
            ++n2;
        }
        this.currCE = 0;
        this.fileInput = false;
        this.initialFileInput = false;
        this.firstRun = true;
    }
}

