/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class VariableScope {
    static int i = 0;
    private Set declaredVariables = new HashSet();
    private Set referencedVariables = new HashSet();
    private Set varsDeclaredHere = null;
    private VariableScope parent;
    private List children = new ArrayList();
    String name = null;

    public VariableScope() {
        this.name = String.valueOf(i++);
    }

    public VariableScope(VariableScope parent) {
        this.parent = parent;
        parent.children.add(this);
        this.name = String.valueOf(i);
    }

    public Set getDeclaredVariables() {
        return this.declaredVariables;
    }

    public Set getReferencedVariables() {
        return this.referencedVariables;
    }

    public List getChildren() {
        return this.children;
    }

    public VariableScope createCompositeChildScope() {
        VariableScope answer = new VariableScope();
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            answer.appendRecursive((VariableScope)iter.next());
        }
        answer.parent = this;
        return answer;
    }

    public VariableScope createRecursiveChildScope() {
        VariableScope answer = this.createCompositeChildScope();
        answer.referencedVariables.addAll(this.referencedVariables);
        answer.declaredVariables.addAll(this.declaredVariables);
        return answer;
    }

    public VariableScope createRecursiveParentScope() {
        VariableScope answer = new VariableScope();
        VariableScope node = this;
        do {
            answer.append(node);
        } while ((node = node.parent) != null);
        return answer;
    }

    protected void append(VariableScope scope) {
        this.referencedVariables.addAll(scope.referencedVariables);
        this.declaredVariables.addAll(scope.declaredVariables);
    }

    protected void appendRecursive(VariableScope scope) {
        this.append(scope);
        Iterator iter = scope.children.iterator();
        while (iter.hasNext()) {
            this.appendRecursive((VariableScope)iter.next());
        }
    }

    public void computeRealDeclares() {
        if (this.varsDeclaredHere == null) {
            this.varsDeclaredHere = new HashSet();
        }
        Set decls = this.declaredVariables;
        Iterator iter = decls.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            if (this.createRecursiveParentScope().getDeclaredVariables().contains(var)) continue;
            this.varsDeclaredHere.add(var);
        }
    }

    public Set getVarsDeclaredHere() {
        if (this.varsDeclaredHere == null) {
            this.computeRealDeclares();
        }
        return this.varsDeclaredHere;
    }

    public void setVarsDeclaredHere(Set varsDeclaredHere) {
        this.varsDeclaredHere = varsDeclaredHere;
    }

    public VariableScope getParent() {
        return this.parent;
    }
}

