/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyClassLoader;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;

public class CompileUnit {
    private List modules = new ArrayList();
    private Map classes = new HashMap();
    private CompilerConfiguration config;
    private GroovyClassLoader classLoader;
    private CodeSource codeSource;
    private Map classesToCompile = new HashMap();

    public CompileUnit(GroovyClassLoader classLoader, CompilerConfiguration config) {
        this(classLoader, null, config);
    }

    public CompileUnit(GroovyClassLoader classLoader, CodeSource codeSource, CompilerConfiguration config) {
        this.classLoader = classLoader;
        this.config = config;
        this.codeSource = codeSource;
    }

    public List getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        if (node == null) {
            return;
        }
        this.modules.add(node);
        node.setUnit(this);
        this.addClasses(node.getClasses());
    }

    public ClassNode getClass(String name) {
        ClassNode cn = (ClassNode)this.classes.get(name);
        if (cn != null) {
            return cn;
        }
        return (ClassNode)this.classesToCompile.get(name);
    }

    public List getClasses() {
        ArrayList answer = new ArrayList();
        Iterator iter = this.modules.iterator();
        while (iter.hasNext()) {
            ModuleNode module = (ModuleNode)iter.next();
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfiguration getConfig() {
        return this.config;
    }

    public GroovyClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    void addClasses(List classList) {
        Iterator iter = classList.iterator();
        while (iter.hasNext()) {
            this.addClass((ClassNode)iter.next());
        }
    }

    public void addClass(ClassNode node) {
        String name = (node = node.redirect()).getName();
        Object stored = this.classes.get(name);
        if (stored != null && stored != node) {
            throw new RuntimeException("Error: duplicate class declaration for name: " + name + " and class: " + node);
        }
        this.classes.put(name, node);
        if (this.classesToCompile.containsKey(name)) {
            ClassNode cn = (ClassNode)this.classesToCompile.get(name);
            cn.setRedirect(node);
            this.classesToCompile.remove(name);
        }
    }

    public void addClassNodeToCompile(ClassNode node) {
        this.classesToCompile.put(node.getName(), node);
    }

    public boolean hasClassNodeToCompile() {
        return this.classesToCompile.size() != 0;
    }
}

