/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ArrayExpression
extends Expression {
    private List expressions;
    private Expression sizeExpression;
    private ClassNode elementType;

    private ArrayExpression(ClassNode elementType, List expressions, Expression sizeExpression) {
        super.setType(elementType.makeArray());
        this.elementType = elementType;
        this.expressions = expressions;
        this.sizeExpression = sizeExpression;
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof Expression) continue;
            throw new ClassCastException("Item: " + item + " is not an Expression");
        }
    }

    public ArrayExpression(ClassNode elementType, List expressions) {
        this(elementType, expressions, null);
    }

    public ArrayExpression(ClassNode elementType, Expression sizeExpression) {
        this(elementType, Collections.EMPTY_LIST, sizeExpression);
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitArrayExpression(this);
    }

    public boolean isDynamic() {
        return false;
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return new ArrayExpression(this.elementType, this.transformExpressions(this.expressions, transformer), transformer.transform(this.sizeExpression));
    }

    public Expression getExpression(int i) {
        Object object = this.expressions.get(i);
        return (Expression)object;
    }

    public ClassNode getElementType() {
        return this.elementType;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Expression getSizeExpression() {
        return this.sizeExpression;
    }

    public String toString() {
        return super.toString() + this.expressions;
    }
}

