/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.ClassCompletionVerifier;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.JSRVariableScopeCodeVisitor;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.InputStreamReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.syntax.ClassSource;
import org.codehaus.groovy.syntax.SourceSummary;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.tools.GroovyClass;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CompilationUnit
extends ProcessingUnit {
    protected HashMap sources;
    protected Map summariesBySourceName;
    protected Map summariesByPublicClassName;
    protected Map classSourcesByPublicClassName;
    protected ArrayList names;
    protected LinkedList queuedSources;
    protected CompileUnit ast;
    protected ArrayList generatedClasses;
    protected Verifier verifier;
    protected ClassCompletionVerifier completionVerifier;
    protected boolean debug;
    protected boolean configured;
    protected ClassgenCallback classgenCallback;
    protected ProgressCallback progressCallback;
    private ResolveVisitor resolveVisitor;
    private LoopBodyForSourceUnitOperations parse = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            source.parse();
            if (CompilationUnit.this.progressCallback != null) {
                CompilationUnit.this.progressCallback.call(source, CompilationUnit.this.phase);
            }
        }
    };
    private LoopBodyForSourceUnitOperations summarize = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            SourceSummary sourceSummary = source.getSourceSummary();
            if (sourceSummary != null) {
                CompilationUnit.this.summariesBySourceName.put(source.getName(), sourceSummary);
                List publicClassSources = sourceSummary.getPublicClassSources();
                if (publicClassSources == null || publicClassSources.size() == 0) {
                    CompilationUnit.this.summariesByPublicClassName.put("*NoName*", sourceSummary);
                } else {
                    Iterator itr = publicClassSources.iterator();
                    while (itr.hasNext()) {
                        ClassSource classSource = (ClassSource)itr.next();
                        CompilationUnit.this.summariesByPublicClassName.put(classSource.getName(), sourceSummary);
                        CompilationUnit.this.classSourcesByPublicClassName.put(classSource.getName(), classSource);
                    }
                }
            }
        }
    };
    private LoopBodyForSourceUnitOperations resolve = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            List classes = source.ast.getClasses();
            Iterator it = classes.iterator();
            while (it.hasNext()) {
                ClassNode node = (ClassNode)it.next();
                CompilationUnit.this.resolveVisitor.startResolving(node, source);
            }
        }
    };
    private LoopBodyForSourceUnitOperations convert = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            source.convert();
            CompilationUnit.this.ast.addModule(source.getAST());
            if (CompilationUnit.this.progressCallback != null) {
                CompilationUnit.this.progressCallback.call(source, CompilationUnit.this.phase);
            }
        }
    };
    private LoopBodyForPrimaryClassNodeOperations classgen = new LoopBodyForPrimaryClassNodeOperations(){

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            String sourceName;
            try {
                CompilationUnit.this.verifier.visitClass(classNode);
            }
            catch (GroovyRuntimeException rpe) {
                ASTNode node = rpe.getNode();
                CompilationUnit.this.getErrorCollector().addError(new SyntaxException(rpe.getMessage(), null, node.getLineNumber(), node.getColumnNumber()), source);
            }
            if (source != null && !classNode.isSynthetic() && !"false".equals(System.getProperty("groovy.jsr.check"))) {
                JSRVariableScopeCodeVisitor scopeVisitor = new JSRVariableScopeCodeVisitor(null, source);
                scopeVisitor.visitClass(classNode);
                source.getErrorCollector().failIfErrors();
            }
            ClassVisitor visitor = CompilationUnit.this.createClassVisitor();
            String string = sourceName = source == null ? classNode.getModule().getDescription() : source.getName();
            if (sourceName != null) {
                sourceName = sourceName.substring(Math.max(sourceName.lastIndexOf(92), sourceName.lastIndexOf(47)) + 1);
            }
            AsmClassGenerator generator = new AsmClassGenerator(context, visitor, CompilationUnit.this.classLoader, sourceName);
            generator.visitClass(classNode);
            CompilationUnit.this.completionVerifier.visitClass(classNode);
            byte[] bytes = ((ClassWriter)visitor).toByteArray();
            CompilationUnit.this.generatedClasses.add(new GroovyClass(classNode.getName(), bytes));
            if (CompilationUnit.this.classgenCallback != null) {
                CompilationUnit.this.classgenCallback.call(visitor, classNode);
            }
            LinkedList innerClasses = generator.getInnerClasses();
            while (!innerClasses.isEmpty()) {
                CompilationUnit.this.classgen.call(source, context, (ClassNode)innerClasses.removeFirst());
            }
        }
    };
    private LoopBodyForSourceUnitOperations mark = new LoopBodyForSourceUnitOperations(){

        public void call(SourceUnit source) throws CompilationFailedException {
            if (source.phase < CompilationUnit.this.phase) {
                source.gotoPhase(CompilationUnit.this.phase);
            }
            if (source.phase == CompilationUnit.this.phase && CompilationUnit.this.phaseComplete && !source.phaseComplete) {
                source.completePhase();
            }
        }
    };

    public CompilationUnit() {
        this((CompilerConfiguration)null, (CodeSource)null, (GroovyClassLoader)null);
    }

    public CompilationUnit(GroovyClassLoader loader) {
        this(null, null, loader);
    }

    public CompilationUnit(CompilerConfiguration configuration) {
        this(configuration, (CodeSource)null, (GroovyClassLoader)null);
    }

    public CompilationUnit(CompilerConfiguration configuration, CodeSource security, GroovyClassLoader loader) {
        super(configuration, loader, null);
        this.names = new ArrayList();
        this.queuedSources = new LinkedList();
        this.sources = new HashMap();
        this.summariesBySourceName = new HashMap();
        this.summariesByPublicClassName = new HashMap();
        this.classSourcesByPublicClassName = new HashMap();
        this.ast = new CompileUnit(this.classLoader, security, this.configuration);
        this.generatedClasses = new ArrayList();
        this.verifier = new Verifier();
        this.completionVerifier = new ClassCompletionVerifier();
        this.resolveVisitor = new ResolveVisitor(this);
        this.classgenCallback = null;
    }

    public void configure(CompilerConfiguration configuration) {
        super.configure(configuration);
        this.debug = configuration.getDebug();
        if (!this.configured && this.classLoader instanceof GroovyClassLoader) {
            this.appendCompilerConfigurationClasspathToClassLoader(configuration, this.classLoader);
        }
        this.configured = true;
    }

    private void appendCompilerConfigurationClasspathToClassLoader(CompilerConfiguration configuration, GroovyClassLoader classLoader) {
        Iterator iterator = configuration.getClasspath().iterator();
        while (iterator.hasNext()) {
            classLoader.addClasspath((String)iterator.next());
        }
    }

    public CompileUnit getAST() {
        return this.ast;
    }

    public Map getSummariesBySourceName() {
        return this.summariesBySourceName;
    }

    public Map getSummariesByPublicClassName() {
        return this.summariesByPublicClassName;
    }

    public Map getClassSourcesByPublicClassName() {
        return this.classSourcesByPublicClassName;
    }

    public boolean isPublicClass(String className) {
        return this.summariesByPublicClassName.containsKey(className);
    }

    public List getClasses() {
        return this.generatedClasses;
    }

    public ClassNode getFirstClassNode() {
        return (ClassNode)((ModuleNode)this.ast.getModules().get(0)).getClasses().get(0);
    }

    public ClassNode getClassNode(final String name) {
        ClassNode[] result;
        block2: {
            result = new ClassNode[]{null};
            LoopBodyForPrimaryClassNodeOperations handler = new LoopBodyForPrimaryClassNodeOperations(){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) {
                    if (classNode.getName().equals(name)) {
                        result[0] = classNode;
                    }
                }
            };
            try {
                this.applyToPrimaryClassNodes(handler, false);
            }
            catch (CompilationFailedException e) {
                if (!this.debug) break block2;
                e.printStackTrace();
            }
        }
        return result[0];
    }

    public void addSources(String[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            this.addSource(file);
        }
    }

    public void addSources(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            this.addSource(files[i]);
        }
    }

    public SourceUnit addSource(File file) {
        return this.addSource(new SourceUnit(file, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(URL url) {
        return this.addSource(new SourceUnit(url, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(String name, InputStream stream) {
        InputStreamReaderSource source = new InputStreamReaderSource(stream, this.configuration);
        return this.addSource(new SourceUnit(name, source, this.configuration, this.classLoader, this.getErrorCollector()));
    }

    public SourceUnit addSource(SourceUnit source) {
        String name = source.getName();
        source.setClassLoader(this.classLoader);
        Iterator iter = this.queuedSources.iterator();
        while (iter.hasNext()) {
            SourceUnit su = (SourceUnit)iter.next();
            if (!name.equals(su.getName())) continue;
            return su;
        }
        this.queuedSources.add(source);
        return source;
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator nameIterator;
            {
                this.nameIterator = CompilationUnit.this.names.iterator();
            }

            public boolean hasNext() {
                return this.nameIterator.hasNext();
            }

            public Object next() {
                String name = (String)this.nameIterator.next();
                return CompilationUnit.this.sources.get(name);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addClassNode(ClassNode node) {
        ModuleNode module = new ModuleNode(this.ast);
        this.ast.addModule(module);
        module.addClass(node);
    }

    public void setClassgenCallback(ClassgenCallback visitor) {
        this.classgenCallback = visitor;
    }

    public void setProgressCallback(ProgressCallback callback) {
        this.progressCallback = callback;
    }

    public void compile() throws CompilationFailedException {
        this.compile(9);
    }

    public void compile(int throughPhase) throws CompilationFailedException {
        block4: {
            this.gotoPhase(1);
            while (true) {
                if (this.dequeued()) {
                    continue;
                }
                if (throughPhase < 2) break block4;
                this.gotoPhase(2);
                this.parse();
                if (this.dequeued()) continue;
                if (throughPhase < 3) break block4;
                this.gotoPhase(3);
                this.convert();
                if (this.dequeued()) continue;
                if (throughPhase < 7) break block4;
                this.gotoPhase(4);
                this.semanticAnalysis();
                if (this.dequeued()) continue;
                if (throughPhase < 7) break block4;
                this.gotoPhase(7);
                Iterator modules = this.ast.getModules().iterator();
                while (modules.hasNext()) {
                    ModuleNode module = (ModuleNode)modules.next();
                    module.sortClasses();
                }
                this.classgen();
                if (this.dequeued()) continue;
                if (throughPhase < 8) break block4;
                this.gotoPhase(8);
                this.output();
                if (!this.dequeued()) break;
            }
            if (throughPhase >= 9) {
                this.gotoPhase(9);
            }
        }
    }

    protected boolean dequeued() throws CompilationFailedException {
        boolean dequeue;
        boolean bl = dequeue = !this.queuedSources.isEmpty();
        while (!this.queuedSources.isEmpty()) {
            SourceUnit su = (SourceUnit)this.queuedSources.removeFirst();
            String name = su.getName();
            this.names.add(name);
            this.sources.put(name, su);
        }
        if (dequeue) {
            this.gotoPhase(1);
        }
        return dequeue;
    }

    public void parse() throws CompilationFailedException {
        if (this.phase != 2) {
            throw new GroovyBugError("CompilationUnit not read for parse()");
        }
        this.applyToSourceUnits(this.parse);
        this.applyToSourceUnits(this.summarize);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
    }

    public void convert() throws CompilationFailedException {
        if (this.phase != 3) {
            throw new GroovyBugError("CompilationUnit not ready for convert()");
        }
        this.applyToSourceUnits(this.convert);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
    }

    public void semanticAnalysis() throws CompilationFailedException {
        if (this.phase != 4) {
            throw new GroovyBugError("CompilationUnit not ready for semanticAnalysis()");
        }
        this.applyToSourceUnits(this.resolve);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
    }

    public void classgen() throws CompilationFailedException {
        if (this.phase != 7) {
            throw new GroovyBugError("CompilationUnit not ready for classgen()");
        }
        this.applyToPrimaryClassNodes(this.classgen, true);
        this.completePhase();
        this.applyToSourceUnits(this.mark);
        if (this.progressCallback != null) {
            this.progressCallback.call(this, this.phase);
        }
    }

    protected ClassVisitor createClassVisitor() {
        return new ClassWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void output() throws CompilationFailedException {
        if (!(this.phase == 8 || this.phase == 7 && this.phaseComplete)) {
            throw new GroovyBugError("CompilationUnit not ready for output()");
        }
        boolean failures = false;
        Iterator iterator = this.generatedClasses.iterator();
        while (iterator.hasNext()) {
            GroovyClass gclass = (GroovyClass)iterator.next();
            String name = gclass.getName().replace('.', File.separatorChar) + ".class";
            File path = new File(this.configuration.getTargetDirectory(), name);
            File directory = path.getParentFile();
            if (directory != null && !directory.exists()) {
                directory.mkdirs();
            }
            byte[] bytes = gclass.getBytes();
            FileOutputStream stream = null;
            stream = new FileOutputStream(path);
            stream.write(bytes, 0, bytes.length);
            Object var11_10 = null;
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (Exception e2) {}
            continue;
            {
                catch (IOException e) {
                    this.getErrorCollector().addError(Message.create(e.getMessage(), this));
                    failures = true;
                    var11_10 = null;
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.getErrorCollector().failIfErrors();
        this.completePhase();
        this.applyToSourceUnits(this.mark);
        if (this.progressCallback != null) {
            this.progressCallback.call(this, this.phase);
        }
    }

    protected void mark() throws CompilationFailedException {
        this.applyToSourceUnits(this.mark);
    }

    public void applyToSourceUnits(LoopBodyForSourceUnitOperations body) throws CompilationFailedException {
        boolean failures = false;
        Iterator keys = this.names.iterator();
        while (keys.hasNext()) {
            String name = (String)keys.next();
            SourceUnit source = (SourceUnit)this.sources.get(name);
            if (source.phase >= this.phase && (source.phase != this.phase || source.phaseComplete)) continue;
            try {
                body.call(source);
            }
            catch (CompilationFailedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new GroovyBugError(e);
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    private List getPrimaryClassNodes(boolean sort) {
        ArrayList<ClassNode> unsorted = new ArrayList<ClassNode>();
        Iterator modules = this.ast.getModules().iterator();
        while (modules.hasNext()) {
            ModuleNode module = (ModuleNode)modules.next();
            Iterator classNodes = module.getClasses().iterator();
            while (classNodes.hasNext()) {
                ClassNode classNode = (ClassNode)classNodes.next();
                unsorted.add(classNode);
            }
        }
        if (!sort) {
            return unsorted;
        }
        int[] index = new int[unsorted.size()];
        int i = 0;
        Iterator iter = unsorted.iterator();
        while (iter.hasNext()) {
            int count = 0;
            for (ClassNode element = (ClassNode)iter.next(); element != null; element = element.getSuperClass()) {
                ++count;
            }
            index[i] = count;
            ++i;
        }
        ArrayList sorted = new ArrayList(unsorted.size());
        boolean start = false;
        for (int i2 = 0; i2 < index.length; ++i2) {
            int min = -1;
            for (int j = 0; j < index.length; ++j) {
                if (index[j] == -1) continue;
                if (min == -1) {
                    min = j;
                    continue;
                }
                if (index[j] >= index[min]) continue;
                min = j;
            }
            sorted.add(unsorted.get(min));
            index[min] = -1;
        }
        return sorted;
    }

    public void applyToPrimaryClassNodes(LoopBodyForPrimaryClassNodeOperations body, boolean sort) throws CompilationFailedException {
        boolean failures = false;
        Iterator classNodes = this.getPrimaryClassNodes(sort).iterator();
        while (classNodes.hasNext()) {
            try {
                ClassNode classNode = (ClassNode)classNodes.next();
                SourceUnit context = classNode.getModule().getContext();
                if (context != null && context.phase > this.phase) continue;
                body.call(context, new GeneratorContext(this.ast), classNode);
            }
            catch (CompilationFailedException e) {
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (Exception e) {
                failures = true;
                ErrorCollector nestedCollector = null;
                for (Throwable next = e.getCause(); next != e && next != null; next = next.getCause()) {
                    if (!(next instanceof MultipleCompilationErrorsException)) continue;
                    MultipleCompilationErrorsException mcee = (MultipleCompilationErrorsException)next;
                    nestedCollector = mcee.collector;
                    break;
                }
                if (nestedCollector != null) {
                    this.getErrorCollector().addCollectorContents(nestedCollector);
                    continue;
                }
                this.getErrorCollector().addError(new ExceptionMessage(e, this.configuration.getDebug(), this));
            }
        }
        this.getErrorCollector().failIfErrors();
    }

    public abstract class LoopBodyForPrimaryClassNodeOperations {
        public abstract void call(SourceUnit var1, GeneratorContext var2, ClassNode var3) throws CompilationFailedException;
    }

    public abstract class LoopBodyForSourceUnitOperations {
        public abstract void call(SourceUnit var1) throws CompilationFailedException;
    }

    public static abstract class ProgressCallback {
        public abstract void call(ProcessingUnit var1, int var2) throws CompilationFailedException;
    }

    public static abstract class ClassgenCallback {
        public abstract void call(ClassVisitor var1, ClassNode var2) throws CompilationFailedException;
    }
}

