def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}

def successors(node, graph) {
    if(graph.size() == 0)
        return []
    else {
        def hd = head(graph)
        if(node == hd[0])
            return cons(hd[1], successors(node, tail(graph)))
        else
            return successors(node, tail(graph))
    }
}

def graph = [['a', 'b'], ['a', 'c'], ['a', 'd'],
             ['b', 'e'], ['c', 'f'], ['d', 'e'],
             ['e', 'f'], ['e', 'g']
            ]

println "Successors: ${successors('e', graph)}"
