import console.*

def prefix(minutes, seconds) {
    def mins = minutes % 5			// 0 <= mins < 5
    
    if(seconds == 0)
        return ''				// denotes exact
    else if(60 * mins + seconds < 150)		// less than 2 minutes 30 seconds?
        return 'just after'			// denotes just after
    else
        return 'just before'			// denotes just before
}

def verbalizeTime(hours, minutes, seconds) {
    def xHours = [ 0 : 'midnight',     1 : 'one',     2 : 'two',
                   3 : 'three',        4 : 'four',    5 : 'five',
                   6 : 'six',          7 : 'seven',   8 : 'eight',
                   9 : 'nine',        10 : 'ten',    11 : 'eleven'
                 ]
                 
    def xMinutes = [ 0 : '',                 5 : 'five past',         10 : 'ten past',
                    15 : 'quarter past',    20 : 'twenty past',       25 : 'twenty five past',
                    30 : 'half past',       35 : 'twenty five to',    40 : 'twenty to',
                    45 : 'quarter to',      50 : 'ten to',            55 : 'five to'
                   ]
                   
    def xP = prefix(minutes, seconds)
    def h = hours % 12
    if(60 * minutes + seconds >= 60 * 32 + 30) h++
    def m = 5 * minutes.intdiv(5)
    def mins = minutes % 5
    if(60 * mins + seconds >= 60 * 2 + 30) m += 5
    
    printf("%02d:%02d:%02d\t%s %s %s\n", [hours, minutes, seconds, xP, xMinutes[m], xHours[h]])
}

print "Please enter first clock time: "
def hours = Console.readInteger()
def minutes = Console.readInteger()
def seconds = Console.readInteger()

while( ! (hours == 0 && minutes == 0 && seconds == 0)) {

    verbalizeTime(hours, minutes, seconds)
    
    print "Please enter next clock time: "
    hours = Console.readInteger()
    minutes = Console.readInteger()
    seconds = Console.readInteger()
}
