/**
 *  Groovy enhances the standard classes such as File with additional
 *    helper methods that create input output objects.
 *
 *  A simple demonstration of file sorting.
 *
 *  Usage: groovy exercise07.groovy [-r] filename
 */

import java.io.*

def argc = args.size()
if(argc < 1 || argc > 2)
    println "Usage: groovy example07.groovy [-r] filename"
else {
    def rOption = (argc == 2 && args[0] == '-r')
    def fileName = args[argc - 1]
    
    def lines = []
    
    	//  Read from the text file
    new File(fileName).eachLine { line ->
        lines << line
    }
    
    	//  Sort the text
    lines.sort()
    if(rOption)
        lines = lines.reverse()
    
    	//  Write back to text file
    new File(fileName).withPrintWriter { printWriter ->
        for(k in 0..<lines.size()) {
            printWriter.println(lines[k])
        }
    }
}
