/**
 *  exercise05
 *
 */

import textio.*

def addBook(library, bookTitle) {
    library[bookTitle]= []
}

def removeBook(library, bookTitle) {  
    library.remove(bookTitle)      
}

def lendBook(library, bookTitle, borrowerName) {
    library[bookTitle] << borrowerName       
}


def returnBook(library, bookTitle, borrowerName) {
    library[bookTitle].remove(borrowerName)
}

def writeLoanStock(library) {
    println "\nLibrary stock: ${library} \n"
}

def readNumberBorrowedBooks(library, borrowerName) {
    def borrowerNames = library.values().toList()
    borrowerNames = borrowerNames.flatten()
    return borrowerNames.count(borrowerName)
}

def readNumberBorrowers(library, bookTitle) {
    return library[bookTitle].size()
}

def readBorrowers(library, bookTitle) {
    return library[bookTitle]
}

def readBookTitle(){
    ConsoleIO.out.print("\tEnter book title: ")
    return ConsoleIO.in.readLine()
}

def readBorrowerName(){
    ConsoleIO.out.print("\tEnter borrower name: ")
    return ConsoleIO.in.readString()
}

def readMenuSelection(){
    ConsoleIO.out.println()
    ConsoleIO.out.println("0: Quit")
    ConsoleIO.out.println("1: Add new book")
    ConsoleIO.out.println("2: Remove book")
    ConsoleIO.out.println("3: Lend a book")
    ConsoleIO.out.println("4: Return a book")
    ConsoleIO.out.println("5: Display loan stock")
    ConsoleIO.out.println("6: Display number of books on loan to a borrower")
    ConsoleIO.out.println("7: Display number of borrowers of a book")
    ConsoleIO.out.println("8: Display borrowers of a book")
       
    ConsoleIO.out.print("\n\tEnter choice: ")      
    return ConsoleIO.in.readString()
} 

def library = ['Groovy' : ['Ken', 'John'],
               'OOD' : ['Ken'],
               'Java' : ['John', 'Sally'],
               'UML' : ['Sally'],
               'Basic' : []
              ]


def doAddBook = { addBook(library, readBookTitle()) }

def doRemoveBook = { removeBook(library, readBookTitle()) }

def doLendBook = { lendBook(library, readBookTitle(), readBorrowerName()) }

def doReturnBook = { returnBook(library, readBookTitle(), readBorrowerName()) }

def doDisplayLoanStock = { writeLoanStock(library) }

def doDisplayNumberBooksOnLoanToBorrower = {
        def count = readNumberBorrowedBooks(library, readBorrowerName())
        println "\nNumber of books borrowed: ${count}\n"
    }

def doDisplayNumberBorrowersOfBook = {
        def count = readNumberBorrowers(library, readBookTitle())
        println "\nNumber of borrowers: ${count}\n"  
    }

def doDisplayBorrowersOfBook = {
         def borrowerNames = readBorrowers(library, readBookTitle())
         println "\nBorrowers: ${borrowerNames.sort()}\n"
}

def menu = [ '1' : doAddBook, '2' : doRemoveBook,
             '3' : doLendBook,'4' : doReturnBook,
             '5' : doDisplayLoanStock, '6' : doDisplayNumberBooksOnLoanToBorrower,
             '7' : doDisplayNumberBorrowersOfBook   
           ]
           
menu['8'] = doDisplayBorrowersOfBook 

def choice = readMenuSelection()

while(choice != '0'){
    menu[choice].call()  
    choice = readMenuSelection()
}

ConsoleIO.out.println("\nSystem closing\n")