/**
 *  A Library populated with Book objects. We can add a new Book
 *    to the Library, and we can obtain a listing of the stock.
 */

import textio.*



class Book {
    
    String toString() {		// redefinition
        return "Book: ${catalogNumber}: ${title} by: ${author}"
    }
    
// ---------- properties ----------------------------------

    @Property catalogNumber
    @Property title
    @Property author
    
}



class Library {
        
    def addBook(bk) {
        loanStock[bk.catalogNumber] = bk
    }
    
    def addBook(catalogNumber, title, author) {
        def bk = new Book(catalogNumber : catalogNumber, title : title, author : author)
        loanStock[catalogNumber] = bk
    }
    
    def displayStock() {
        println "Library: ${name}"
        println "======================"
        
        loanStock.each { entry -> println "    ${entry.value}" }
    }

// ---------- properties ----------------------------------

    @Property name
    @Property loanStock = [ : ]
}



	//  Create a library object
def lib = new Library(name : 'Dunning')

	//  Create some books...
def bk1 = new Book(catalogNumber : 111, title : 'Groovy', author : 'Ken')
def bk2 = new Book(catalogNumber : 222, title : 'OOD', author : 'Ken')
def bk3 = new Book(catalogNumber : 333, title : 'UML', author : 'John')


	//  ...add then to the loan stock
lib.addBook(bk1)
lib.addBook(bk2)
lib.addBook(bk3)

lib.addBook(444, 'Java', 'Ken and John')

	//  See stock
lib.displayStock()
