interface EmployeeIF {
    def abstract getName()
    def abstract getPayrollNumber()
}

abstract class EmployeeAB implements EmployeeIF {

    def abstract computeMonthlyPay()
    
// ---------- properties ----------------------------------

    @Property name
    @Property payrollNumber
}

class SalariedEmployee extends EmployeeAB {

    def computeMonthlyPay() {
        return salary / 12
    }
    
// ---------- properties ----------------------------------

    @Property salary
}


class HourlyEmployee extends EmployeeAB {

    def computeMonthlyPay() {
        return payRate * hoursWorked
    }
    
// ---------- properties ----------------------------------

    @Property payRate		// per hour
    @Property hoursWorked	// per month
}


class Company {
    
    def hire(employee) {
        employees[employee.payrollNumber] = employee
    }
    
    def getMonthlySalaryBill() {
        def total = 0
        
        employees.each { number, employee ->
            total += employee.computeMonthlyPay()
        }
        
        return total
    }
    
// ---------- properties ----------------------------------

    @Property name
    @Property employees = [ : ]
}

def co = new Company(name : 'Napier')

def se1 = new SalariedEmployee(name : 'Ken', payrollNumber : 1111, salary : 12000)
def se2 = new SalariedEmployee(name : 'John', payrollNumber : 2222, salary : 18000)

def he1 = new HourlyEmployee(name : 'Sally', payrollNumber : 3333, payRate : 5, hoursWorked : 160)

co.hire(se1)
co.hire(se2)
co.hire(he1)

println "Total monthly bill: ${co.getMonthlySalaryBill()}"	// output: 3300
