/**
 *  A set of expenses is submitted having the form:
 *
 *    name    amount    reason
 */

def totalExpenses(expenseLines) {
    def total = 0
    expenseLines.each { expenseLine ->
        def expense = expenseLine.tokenize()
        def matcher = expense[1] =~ '([0-9]*)\\.([0-9]*)'
        matcher.matches()
        total += 100 * matcher[0][1].toInteger() + matcher[0][2].toInteger()
    }
    return total / 100
}

def expensesData = ['John   45.00    Train',
                    'Ken   102.20    Air',
                    'Sally  22.20    Supplies']

println "Total expenses: ${totalExpenses(expensesData)}"
