/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. The class properties are
 *    implicitly public as are the automatically generated
 *    getters and setters.
 */

class Account {
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
// ---------- properties ----------------------------------

    def number			// account number
    def balance			// current balance
}

	//  Create an instance
def acc = new Account(number : 'ABC123', balance : 1200)

	//  Change state with the automatic setters
acc.number = 'DEF456'
acc.balance = 1500

	//  Now use the automatic getters
println "Account: ${acc.number}; balance: ${acc.balance}"
