/**
 *  A specialized builder which monitors its execution. The subclass
 *    defines the abstract method setParent and the various createNode
 *    methods. The hook method nodeCompleted is also implemented. Each
 *    displays its name and parameters when it is invoked.
 */

import groovy.util.*

class MonitorBuilder extends BuilderSupport {

    protected void setParent(Object parent, Object child) {
        println "setParent(${parent}, ${child})"
    }
    
    protected Object createNode(Object name) {
        println "createNode(${name})"
        return name
    }

    protected Object createNode(Object name, Object value) {
        println "createNode(${name}, ${value})"
        return name
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        println "createNode(${name}, ${attributes}, ${value})"
        return name
    }

    protected Object createNode(Object name, Map attributes) {
        return createNode(name, attributes, null)
    }
    
    protected void nodeCompleted(Object parent, Object node) {
        println "nodeCompleted(${parent}, ${node})"
    }
}

def mB = new MonitorBuilder()

def monitor = mB.database(name : 'library') {
    table(name : 'Book') {
        field(name : 'title', type : 'text')
        field(name : 'isbn', type : 'text')
        field(name : 'price', type : 'integer')
        field(name : 'author', type : 'id')
        field(name : 'publisher', type : 'id')
    }
}
