/**
 *  A simple GUI demonstrating a simple menu. The menu items
 *    simply echo a message on to the console. The menus are
 *    constructed from lists of the menus, their menu items, etc.
 */

import groovy.swing.SwingBuilder
import javax.swing.*

	//  Menu handlers
def fileNew = {
    println 'File + New'
}

def fileOpen = {
    println 'File + Open...'
}

def fileSave = {
    println 'File + Save'
}

def fileSaveAs = {
    println 'File + Save as...'
}

def fileExit = {
    System.exit(0)
}

def helpAbout = {
    println 'Help + About'
}


	//  Create a builder
def sB = new SwingBuilder()

	//  Now the frame
def frame = sB.frame(title : 'Example02', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    menuBar {
        def fileMenu = [['File',	'F'],
                        ['New',		'N',	fileNew		],
                        ['Open...',	'O',	fileOpen	],
                        null,
                        ['Save',	'S',	fileSave	],
                        ['Save as...',	'A',	fileSaveAs	],
                        null,
                        ['Exit',	'X',	fileExit	]
                       ]
                       
        def helpMenu = [['Help',	'H'],
                        ['About',	'A',	helpAbout	]
                       ]
                       
        def menus = [fileMenu, helpMenu]
        
        menus.each { mnu ->
            def mnuDetails = mnu[0]
            sB.menu(text : mnuDetails[0], mnemonic : mnuDetails[1]) {
                for(k in 1..<mnu.size()) {
                    def mnuItem = mnu[k]
                    if(mnuItem == null)
                        sB.separator()
                    else
                        sB.menuItem() {
                            sB.action(name : mnuItem[0], mnemonic : mnuItem[1], closure : mnuItem[2])
                        }
                }
            }
        }
    }
}

	//  Now show it
frame.pack()
frame.setVisible(true)
