/**
 *  A simple GUI demonstrating a simple menu and corresponding tool bar.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Text area of set size
class FixedTextArea extends JTextArea {

    Dimension getMinimumSize() { return TEXTAREASIZE }
    Dimension getMaximumSize() { return TEXTAREASIZE }
    Dimension getPreferredSize() { return TEXTAREASIZE }

    private static final TEXTAREASIZE = new Dimension(400, 400)
}

	//  Menu handlers
def fileNew = {
    println 'File + New'
}

def fileOpen = {
    println 'File + Open...'
}

def fileSave = {
    println 'File + Save'
}

def fileSaveAs = {
    println 'File + Save as...'
}

def fileExit = {
    System.exit(0)
}

def helpAbout = {
    println 'Help + About'
}


	//  Create a builder
def sB = new SwingBuilder()


	//  Now the frame
def frame = sB.frame(title : 'Example03', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    def fileMenu = [['File',		'F'],
                    ['New',		'N',	true,	fileNew		],
                    ['Open...',		'O',	true,	fileOpen	],
                    null,
                    ['Save',		'S',	true,	fileSave	],
                    ['Save as...',	'A',	false,	fileSaveAs	],
                    null,
                    ['Exit',		'X',	false,	fileExit	]
                   ]
                   
    def helpMenu = [['Help',		'H'],
                    ['About',		'A',	false,	helpAbout	]
                   ]
               
    def menus = [fileMenu, helpMenu]
        
    menuBar {
        menus.each { mnu ->
            def mnuDetails = mnu[0]
            sB.menu(text : mnuDetails[0], mnemonic : mnuDetails[1]) {
                for(k in 1..<mnu.size()) {
                    def mnuItem = mnu[k]
                    if(mnuItem == null)
                        sB.separator()
                    else {
                        sB.menuItem() {
                            sB.action(name : mnuItem[0], mnemonic : mnuItem[1], closure : mnuItem[3])
                        }
                    }
                }
            }
        }
    }
      
    sB.panel(layout : new BorderLayout()) {  
        toolBar(constraints : BorderLayout.NORTH) {
            menus.each { toolMnu ->
                for(k in 1..<toolMnu.size()) {
                    def toolItem = toolMnu[k]
                    if(toolItem != null && toolItem[2] == true) {
                        def toolText = toolItem[0]
                        def toolAction = toolItem[3]
                        sB.button(text : toolText, actionPerformed : toolAction)
                    }
                }
            }
        }
    
        sB.panel(constraints : BorderLayout.CENTER) {
            widget(new FixedTextArea(enabled : false))
        }
    }
    
}

	//  Now show it
frame.pack()
frame.setVisible(true)
