/**
 *  A simple GUI demonstrating the use of a dialog.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Text area of set size
class FixedTextArea extends JTextArea {

    Dimension getMinimumSize() { return TEXTAREASIZE }
    Dimension getMaximumSize() { return TEXTAREASIZE }
    Dimension getPreferredSize() { return TEXTAREASIZE }

    private static final TEXTAREASIZE = new Dimension(400, 400)
}

	//  Builder
def sB = new SwingBuilder()

def loginDialog = null
def nameField = null
def pwordField = null


	//  frame handlers
def loginHandler = {
    loginDialog.setVisible(true)
}


	//  Now the main panel...
def mainPanel = {
    sB.panel(layout : new BorderLayout()) {
        panel(constraints : BorderLayout.WEST) {
            button(text : 'Login', actionPerformed : loginHandler)
        }
        panel(constraints : BorderLayout.CENTER) {
            widget(new FixedTextArea(enabled : false))
        }
    }
}


	//  ...and finally the frame
def frame = sB.frame(title : 'Example04', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}


	// dialog handlers
def okHandler = {
    loginDialog.setVisible(false)
        
    def userName = nameField.getText()
    def userPassword = pwordField.getText()
        
    nameField.setText('')
    pwordField.setText('')
        
    if(userName == '')
        println 'NO user name given'
    else if(userPassword == "")
        println 'NO password given'
    else
        println "User: ${userName}"
}
    
def cancelHandler = {
    loginDialog.setVisible(false)
        
    userName = ''
    userPassword = ''
        
    nameField.setText('')
    pwordField.setText('')
}


def dialogPanel = {
    sB.panel(layout : new BorderLayout()) {
            panel(layout : new GridLayout(2, 2, 5, 5), constraints : BorderLayout.CENTER) {
                label(text : 'Username:', horizontalAlignment : JLabel.RIGHT)
                nameField = textField(text : "", columns : 20)
                label(text : 'Password:', horizontalAlignment : JLabel.RIGHT)
                pwordField = passwordField(text : "", columns : 20)
            }
            panel(constraints : BorderLayout.SOUTH) {
                button(text : 'OK', actionPerformed : okHandler)
                button(text : 'Cancel', actionPerformed : cancelHandler)
            }
    }
}


loginDialog = sB.dialog(owner : frame, title : 'Login', size : [160, 120], modal : true) {
    dialogPanel()
}


	//  Now show it
frame.pack()
frame.setVisible(true)
