/**
println "Hello".compareToIgnoreCase("hello")		// 0
println "Hello".concat(" world")			// Hello world
println "Hello".endsWith("lo")				// true
println "Hello".equalsIgnoreCase("hello")		// true
println "Hello".indexOf("lo")				// 3
println "Hello world".indexOf("o", 6)			// 7
println "Hello".substring(1)				// ello
println "Hello".substring(1, 4)				// ell
**/

// Other Groovy methods
def message = 'Hello'
println "center#1: [${message.center(11)}]"
println "center#2: [${message.center(3)}]"
println "center#3: [${message.center(11, '#')}]"

println "contains#1: ${message.contains('llo')}"
println "contains#2: ${message.contains('he')}"

println "count#1: ${message.count('l')}"
println "count#2: ${message.count('ll')}"
println "count#3: ${message.count('h')}"

message.eachMatch('.') { ch -> println ch }

println "getAt#1: [${message.getAt(0)}]"
//println "getAt#2: [${message.getAt(6)}]"		// Index out of bounds exception
println "getAt#3: [${message.getAt(0..<3)}]"
println "getAt#4: [${message.getAt([0, 2, 4])}]"
//println "getAt#5: ${message.getAt([0, 2, 4, 6])}"	// Index out of bounds exception

println "leftShift#1: [${message.leftShift(' world')}]"
println "leftShift#2: [${message << ' world'}]"

println "minus#1: [${message.minus('ell')}]"
println "minus#2: [${message - 'ell'}]"

println "next#1: [${message.next()}]"
println "next#2: [${message++}]"
println "next#3: [${++message}]"

message = "Hello"
println "padLeft#1: [${message.padLeft(4)}]"
println "padLeft#2: [${message.padLeft(11)}]"
println "padLeft#3: [${message.padLeft(11, '#')}]"

println "padRight#1: [${message.padRight(4)}]"
println "padRight#2: [${message.padRight(11)}]"
println "padRight#3: [${message.padRight(11, '#')}]"

println "plus#1: [${message.plus(' world')}]"
println "plus#2: [${message +' world'}]"

println "previous#1: [${message.previous()}]"
println "previous#2: [${message--}]"
println "previous#3: [${--message}]"

message = "Hello"

println "replaceAll: ${message.replaceAll('[a-z]') { ch -> ch.toUpperCase() }}"

println "reverse: [${message.reverse()}]"

println "size: [${message.size()}]"

println "toCharacter: [${message.toCharacter()}]"
println "toDouble: [${'123'.toDouble()}]"		// and: toFloat toInteger toLong


println "toList: ${message.toList()}"

message = "Hello world"
println "tokenize#1: ${message.tokenize()}"
println "tokenize#2: ${message.tokenize('l')}"
