/**
 *  Groovy enhances the standard classes such as File with additional
 *    methods that accept closures as parameters. Method eachFile is
 *    applied to a directory, accepts a closure and iterates over each
 *    file in the directory.
 */

import java.io.File

	//  List the content of a directory File
def listDir(dirFile, indent) {
    dirFile.eachFile { file ->
        (0..<indent).each { print " " }
        println "${file.getName()}"
        if(file.isDirectory())
            listDir(file, 2 + indent)
    }
}

	//  Print the content of a named directory
def printDir(dirName) {
    listDir(new File(dirName), 0)
}

if(args.size() != 1 || new File(args[0]).isDirectory() == false)
    println 'Usage: example04 directory'
else {
	//  Print the current directory
    printDir(args[0])
}
