/**
 *  Groovy enhances the standard classes such as File with additional
 *    helper methods that create input output objects.
 *
 *  A simple demonstration of file copying.
 */

import java.io.*

if(args.size() != 2)
    println 'Usage: example07 filename filename'
else {
	//  Write to a destination file
    new File(args[1]).withPrintWriter { printWriter ->

	//  Copy each line of the file
        new File(args[0]).eachLine { line ->
            printWriter.println(line)
        }
    }
}

