/**
 *  An illustration of class specialization. Class CurrentAccount
 *    is defined as a specialization of the class Account.
 */

class Account {

    String toString() {		// redefinition
        return "${number}; ${balance}"
    }
    
// ---------- properties ----------------------------------

    def number
    def balance
    
}

class CurrentAccount extends Account {

    String toString() {
        return 'Current Account: ' + super.toString() + "; ${overdraftLimit}"
    }
    
// ---------- properties ----------------------------------

    def overdraftLimit
}

	//  populate a list with the instances
def accounts = [new Account(number : 'AAA111', balance : 1000),
                new CurrentAccount(number : 'BBB222', balance : 2000, overdraftLimit : 400),
                new CurrentAccount(number : 'CCC333', balance : 3000, overdraftLimit : 800)]

	//  now display each
accounts.each { acc ->
    println acc			// automatically call toString
}
