/**
 *  Exercise03.groovy
 *
 *  A Library populated with Book and Journal objects. We can add new
 *    Book and Journals to the Library, and we can obtain a listing
 *    of the stock. Borrowers are registered with the library and can
 *    borrow and return publications.We can obtain a listing of the 
 *    borrowers' details as well as the Books and Journals they have on
 *    loan.
 */


import textio.*



def readMenuSelection() {
    println()
    println('0: Quit')
    println('1: Add new publication')
    println('2: Display stock')
    println('3: Display publications available for loan')
    println('4: Display publications on loan')
    println('5: Register new borrower')
    println('6: Display borrowers')
    println('7: Lend one publication')
    println('8: Return one publication')
    
    print('\n\tEnter choice>>> ')
    return ConsoleIO.in.readString()
}


	//  create a new Library object
def lib = new Library(name : 'Dunning')

	//  make the Action object for it
def action = new Action(library : lib)

	//  make first selection
def choice = readMenuSelection()

while(choice != '0') {

    if(choice == '1') {					// use-case: Add new publication
        action.addPublication()
    } else if(choice == '2') {				// use-case: Display stock
        action.displayStock()
    } else if(choice == '3') {				// use-case: Display stock available for loan
        action.displayPublicationsAvailableForLoan()
    } else if(choice == '4') {				// use-case: Display stock on loan
        action.displayPublicationsOnLoan()
    } else if(choice == '5') {				// use-case: Register new borrower
        action.registerBorrower()
    } else if(choice == '6') {				// use-case: Display borrowers
        action.displayBorrowers()
    } else if(choice == '7') {				// use-case: Lend one book/journal
        action.lendPublication()
    } else if(choice == '8') {				// use-case: Return one book/journal
        action.returnPublication()
    } else {
        ConsoleIO.out.println('Unknown selection')
    }
	//  next selection
    choice = readMenuSelection()
}

ConsoleIO.out.println('\nSystem closing')
