import groovy.util.GroovyTestCase

class BorrowerTest extends GroovyTestCase {

   /** 
    * Set up the fixture
    */
   void setUp(){
        bor1 = new Borrower(membershipNumber : '1234', name : 'Jessie')
        	
        bk1 = new Book(catalogNumber : '111', title : 'Groovy', author : 'Ken')
        bk2 = new Book(catalogNumber : '222', title : 'OOD', author : 'Ken')
        bk3 = new Book(catalogNumber : '222', title : 'UML', author : 'John')
    }

    /**
     * Test that a Borrower with no Publications on loan can borrow a Book
     */
    void testAttachPublication_1() {
        def pre = bor1.borrowedPublications.size()
        bor1.attachPublication(bk1)
        def post = bor1.borrowedPublications.size()

        assertTrue('one less publication than expected', post == pre + 1)    
    }

    /**
     * Test that a Borrower with no Publications on loan can borrow two Books
     * with different catalog numbers
     */
    void testAttachPublication_2() {        
        bor1.attachPublication(bk1)
        bor1.attachPublication(bk2)
        def expected = 2
        def actual = bor1.borrowedPublications.size()

        assertTrue('unexpected number of publications', actual == expected)   
    }

    /**
     * Test that an attempt to borrow a Book with the same catalog number
     * as one already borrowed results in no change to the number of Publications
     * borrowed
     */
    void testAttachPublication_3() {       
        bor1.attachPublication(bk2)
        def pre = bor1.borrowedPublications.size()        
        bor1.attachPublication(bk3)
        def post = bor1.borrowedPublications.size()

        assertTrue('one more publication than expected', post == pre)   
    }

    /**
     * Test that an attempt to borrow a Book with the same catalog number
     * as one already borrowed results in no change to the borrowed publications
     */
    void testAttachPublication_4() {
        bor1.attachPublication(bk2)
        bor1.attachPublication(bk3)
        def expected = 'Book: 222: OOD by: Ken'
        def actual = bor1.borrowedPublications['222']

        assertToString(actual, expected)            
    } 

// ---------- properties ----------------------------------

    def bor1
    
    def bk1
    def bk2
    def bk3
	
}