/**
 *  Usage:
 *	groovy build.groovy clean
 *	groovy build.groovy init
 *	groovy build.groovy build
 *	groovy build.groovy run script
 *
 *	groovy build.groovy		default target: build
 */

class Build {

    def clean() {
        aB.delete() {
            aB.fileset(dir : "${SRCDIR}", includes : '**/*.bak')
            aB.fileset(dir : "${SRCDIR}", includes : '**/*.BAK')
            aB.fileset(dir : "${DESTDIR}", includes : '**/*.class')
        }
    }
    
    def init() {
        aB.taskdef(name : 'groovyc', classname : 'org.codehaus.groovy.ant.Groovyc')
        aB.taskdef(name : 'groovy', classname : 'org.codehaus.groovy.ant.Groovy')
    }
    
    def build() {
        this.init()
        aB.groovyc(srcdir : "${SRCDIR}", destdir : "${DESTDIR}", classpath : "${classpath}")
    }
    
    def run(script) {
        this.build()
        aB.groovy(src : script)
    }
    
// ---------- properties ----------------------------------

    @Property aB = new AntBuilder()
    
    @Property BASEDIR	= '.'
    @Property SRCDIR	= BASEDIR
    @Property DESTDIR	= BASEDIR
    
    @Property classpath = aB.path() {
        aB.pathelement(path : "${SRCDIR};${DESTDIR}")
    }
}

def b = new Build()

if(args.size() > 0) {
    def target = args[0]
    if(target == 'clean')
        b.clean()
    else if(target == 'init')
        b.init()
    else if(target == 'build')
        b.build()
    else if(target == 'run')
        b.run(args[1])
    else
        println "Unknown target: ${target}"
} else
    b.build()
