import console.*

class Action {

    def setLibrary(library) {
        this.library = library
    }
    
    def addBook() {
        print('\nEnter book catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter book title: ')
        def title = Console.readLine()
        print('Enter book author: ')
        def author = Console.readLine()
            
        def bk = new Book(catalogNumber : catalogNumber, title : title, author : author)            
        def message =library.addPublication(bk)
        println "\nResult: ${message}\n"
    }

    def addJournal() {
        print('\nEnter journal catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter journal title: ')
        def title = Console.readLine()
        print('Enter journal editor: ')
        def editor = Console.readLine()
            
        def jo = new Journal(catalogNumber : catalogNumber, title : title, editor : editor)            
        def message = library.addPublication(jo)
        println "\nResult: ${message}\n"
    }

    def removePublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()               
        def message = library.removePublication(catalogNumber)        
        println "\nResult: ${message}\n"   
    }

    def displayAllStock() {
        this.printHeader('All publications display')        
        library.loanStock.each { catalogNumber, publication -> println "    ${publication}" }        
    }
    
    def displaySelectedStock() {        
        print('\nEnter start of catalog numbers: ')
        def pattern = Console.readLine()
        pattern = '^' + pattern + '.*'
        def found = false
        
        this.printHeader('Selected publications display') 
        library.loanStock.each { catalogNumber, publication -> if(catalogNumber =~ pattern){
                                     found= true
                                     println "    ${publication}" }
        }
        
        if(found == false)
            println '\nCannot print: No such publications\n'                                  
    }

    def displayOnePublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()
        
        def publication = library.loanStock[catalogNumber]
        if(publication != null) {       
            this.printHeader('One publication display')
            println publication
        }
        else {
            println '\nCannot print: No such publication\n'
        }         
    }
    
    def displayPublicationsAvailableForLoan() {
        this.printHeader('Publications available for loan display')                
        library.loanStock.each { catalogNumber, publication -> if(publication.borrower == null)
                                     println "    ${publication}" }
    }
    
    def displayPublicationsOnLoan() {
        this.printHeader('Publications on loan display')             
        library.loanStock.each { catalogNumber, publication -> if(publication.borrower != null) 
                                     println "    ${publication}" }
    }   
    
    def registerBorrower() {
        print('\nEnter borrower membership number: ')
        def membershipNumber = Console.readLine()
        print('Enter borrower name: ')
        def name = Console.readLine()
        
        def bor = new Borrower(membershipNumber : membershipNumber, name : name)        
        def message = library.registerBorrower(bor)        
        println "\nResult: ${message}\n"
    }
    
    def displayAllBorrowers() {
        this.printHeader('All borrowers display')        
        library.borrowers.each { membershipNumber, borrower ->
            println borrower
            def publications = borrower.borrowedPublications
            publications.each { catalogNumber, publication -> println "   ${publication}" }
        }      
    }
    
    def displaySelectedBorrowers() {               
        print('\nEnter start of membership numbers: ')
        def pattern = Console.readLine()
        pattern = '^' + pattern + '.*'
        def found = false
        
        this.printHeader('Selected borrowers display')
        library.borrowers.each { membershipNumber, borrower ->
            if(membershipNumber =~ pattern){
                found = true
                println borrower
                def publications = borrower.borrowedPublications
                publications.each { catalogNumber, publication -> println "   ${publication}" }
            }  
        }
        
        if(found == false)
            println '\nCannot print: No such borrowers\n'     
    }

    def displayOneBorrower() {
        print('\nEnter borrower membership number: ')
        def membershipNumber = Console.readLine()
        
        def bor = library.borrowers[membershipNumber]               
        if(bor != null) {
            this.printHeader('One borrower display')
            println bor                    
            def publications = bor.borrowedPublications
            publications.each { catalogNumber, publication -> println "   ${publication}" }
        }
        else {
            println '\nCannot print: No such borrower\n'
        } 
    } 
   
    def lendPublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()
        print('Enter borrower membership number: ')
        def membershipNumber = Console.readLine()
        
        def message = library.lendPublication(catalogNumber, membershipNumber)        
        println "\nResult: ${message}\n"
    }
    
    def returnPublication() {
        print('\nEnter publication catalog number: ')
        def catalogNumber = Console.readLine()
        
        def message = library.returnPublication(catalogNumber)        
        println "\nResult: ${message}\n"
    }
    
    private printHeader(detail) {
        println "\nLibrary: ${library.name}: ${detail}"
        println '================\n'
    }

// ---------- properties ----------------------------------

    private library

}
                            