/**
 *  Reusable object to represent an SQL query. Subclasses must implement the
 *    mapRow method to provide an object from the single tuple. The class
 *    implements the template pattern, using the abstract mapRow to construct
 *    the appropriate objects.
 */

abstract class SqlQuery {

    def SqlQuery(sql, query) {
        this.sql = sql
        this.query = query
    }
    
    def execute() {
        def rowsList = sql.rows(query)
        def results = []
        def size = rowsList.size()
        0.upto(size - 1) { index ->
            results << this.mapRow(rowsList[index])
        }
        
        return results
    }
    
    def abstract mapRow(row)
    
// ---------- properties ----------------------------------

    def sql
    def query
}
