/**
 *  The DB includes a simple table entitled 'accounts'. This has
 *    two columns named number and balance. A row from this table
 *    represents a simple bank account.
 */

import groovy.sql.*

def DB = 'jdbc:derby:accountDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

	//  Iterate over the result set
println 'Accounts'
println '  Number     Balance   '
println '+----------+----------+'
sql.eachRow('select * from accounts') { acc ->
    printf('| %-8s | %-8d |\n', [acc.number, acc.balance])
}
println '+----------+----------+'
