/**
 *  The DB includes two tables entitled 'banks' and 'accounts'. The
 *    accounts has two columns named number and balance. The banks
 *    table has a single name column. 
 
 
 
 
 Both tables have an auto-
 *    generated column 'id' which acts as the primary key. Finally,
 *    the account table has a foreign key entitled bankID into the
 *    bank table.
 */

import groovy.sql.*

def DB = 'jdbc:derby:bankDB'
def USER = ''
def PASSWORD = ''
def DRIVER = 'org.apache.derby.jdbc.EmbeddedDriver'

	//  Connect to database
def sql = Sql.newInstance(DB, USER, PASSWORD, DRIVER)

	//  Query the bank table
println 'Banks'
println '  Name                            '
println '+--------------------------------+'
sql.eachRow('select * from banks') { bk ->
    printf('| %-30s |\n', [bk.name])
}
println '+--------------------------------+'
println()

	//  Query the account table
println 'Accounts'
println '  Number     Balance    Bank  '
println '+----------+----------+------+'
sql.eachRow('select * from accounts') { acc ->
    printf('| %-8s | %-8d | %-4s |\n', [acc.number, acc.balance, acc.bankID])
}
println '+----------+----------+------+'
println()

	//  Find the RBS accounts
println 'RBS accounts'
println '  Number     Balance   '
println '+----------+----------+'
sql.eachRow('select * from accounts where bankID = ?', ['RBS']) { acc ->
    printf('| %-8s | %-8d |\n', [acc.number, acc.balance])
}
println '+----------+----------+'
println()
