/**
 *  A simple XML demonstration using a MarkupBuilder.
 *    The example creates some XML representing the
 *    details of a series of books. The details are
 *    provided by a preset map. The resulting XML
 *    is streamed to a named file.
 */

import groovy.xml.MarkupBuilder
import java.io.*

def data = ['1111111111' :	['Groovy',			'Ken Barclay', 'Elsevier'],
            '2222222222' :	['Object Oriented Design',	'John Savage', 'Elsevier'],
            '3333333333' :	['C Programming',		'Ken Barclay', 'Prentice Hall']
           ]
       
	//  Create a builder
def mB = new MarkupBuilder(new File('library.xml').newPrintWriter())

	//  Compose the builder
mB.library() {
    data.each { bk ->
        mB.book() {
            title(bk.value[0])
            author(bk.value[1])
            publisher(bk.value[2])
            isbn(number : bk.key)
        }
    }
}
