/**
 *  A simple Swing demonstration using a SwingBuilder.
 *    The example populates the frame with labels and
 *    text fields as might be used for data entry. The
 *    labels and fields are positioned with the use of
 *    a grid layout manager.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import java.awt.*

	//  Create a builder
def sB = new SwingBuilder()

	//  Compose the builder
def frame = sB.frame(title : 'Example02', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    panel(layout : new GridLayout(3, 2, 5, 5)) {
        label(text : 'Last Name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
        label(text : 'Middle Name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
        label(text : 'First Name:', horizontalAlignment : JLabel.RIGHT)
        textField(text : '', columns : 10)
    }
}

	//  Now show it
frame.pack()
frame.setVisible(true)
