/**
 *  A simple GUI demonstrating a table. The list is pre-initialized with a 
 *    list of staff names, room numbers and telephone extensions.
 */

import groovy.swing.SwingBuilder
import javax.swing.*
import javax.swing.table.*
import java.awt.*

	//  Create a builder
def sB = new SwingBuilder()


	//  Panel carrying the staff list
def tablePanel = {
    sB.panel(constraints : BorderLayout.CENTER) {
        scrollPane() {
            table(selectionMode : ListSelectionModel.SINGLE_SELECTION) {
                def staffList = [[forename : 'Ken',    surname : 'Barclay',  room : 'C48', telephone : 2745],
                                 [forename : 'John',   surname : 'Savage',   room : 'C48', telephone : 2746],
                                 [forename : 'Sally',  surname : 'Smith',    room : 'C46', telephone : 2742],
                                 [forename : 'Peter',  surname : 'Thomson',  room : 'D51', telephone : 2781],
                                 [forename : 'John',   surname : 'Owens',    room : 'C47', telephone : 2744],
                                 [forename : 'Neil',   surname : 'Urquhart', room : 'C66', telephone : 2655],
                                 [forename : 'Jessie', surname : 'Kennedy',  room : 'C50', telephone : 2772],
                                 [forename : 'Jon',    surname : 'Kerridge', room : 'C36', telephone : 2777]
                                ]
                
                tableModel(list : staffList) {
                    closureColumn(header : 'First name', read : {row -> return row.forename})
                    closureColumn(header : 'Last name', read : {row -> return row.surname})
                    closureColumn(header : 'Room', read : {row -> return row.room})
                    closureColumn(header : 'Tel extension', read : {row -> return row.telephone})
                }
            }
        }
    }
}


	//  Now the main panel...
def mainPanel = {
    sB.panel(layout : new BorderLayout()) {
        tablePanel()
    }
}

	//  ...and the frame
def frame = sB.frame(title : 'Example09', location : [100, 100], size : [400, 300], defaultCloseOperation : WindowConstants.EXIT_ON_CLOSE) {
    mainPanel()
}

	//  Now show it
frame.pack()
frame.setVisible(true)
