import java.sql.*
import org.springframework.jdbc.object.*

class PublicationQuery extends MappingSqlQuery {

    def PublicationQuery(ds, borrowers) {
        super(ds, 'select * from publications')
        this.compile()
        
        this.borrowers = borrowers
    }
    
    protected Object mapRow(ResultSet rs, int rowNumber) {
        def pub = null
        
        if(rs.getString('type') == 'BOOK')
            pub = new Book(catalogNumber : rs.getString('catalogNumber'), title : rs.getString('title'), author : rs.getString('author'))
        else
            pub = new Journal(catalogNumber : rs.getString('catalogNumber'), title : rs.getString('title'), editor : rs.getString('editor'))
        
        def borID = rs.getString('borrowerID')
        if(borID != null) {
            def bor = borrowers[borID]
            if(bor != null)
                bor.attachPublication(pub)
        }
        
        return pub
    }

// ---------- properties ----------------------------------

    def borrowers		// map
}
