class Borrower {

    def attachPublication(publication) {
        if(!borrowedPublications.containsKey(publication.catalogNumber)) {
            borrowedPublications[publication.catalogNumber] = publication
            publication.attachBorrower(this)
        }
    }
    
    def detachPublication(publication) {
        borrowedPublications.remove(publication.catalogNumber)
        publication.detachBorrower()
    }
    
    String toString() {
        return "Borrower: ${membershipNumber}; ${name}"
    }
    
// ---------- properties ----------------------------------

    @Property membershipNumber
    @Property name
    @Property borrowedPublications = [ : ]
}