/**
 *  Consider creating a Map from the values in a List. The List comprises inner Lists
 *    of length 2, with the first of the pair to act as the Map key and the second of
 *    the pair is the key value. Such as List might appear as:
 *
 *    [['Ken', 'Barclay'], ['John', 'Savage']]
 *
 *  The most straightforward solution is to use the inject method on the List. This
 *    method takes two parameters: the object we will assemble (in this case a Map)
 *    and a closure specifying the action to take for each item in the List. The closure
 *    has two parameters: the Map that we are assembling and one of the items in the List.
 *    Each item is a List with two elements.
 */

class ListCategory {

    static Map toMap(List list) {
        return list.inject([:]) { hash, inner -> hash[inner[0]] = inner[1]; return hash }
    }
}

use(ListCategory.class) {
    def staff = [['Ken', 'Barclay'], ['John', 'Savage']]
    def staffMap = staff.toMap()
    println "staffMap: ${staffMap}"
}

