/**
 *  A class to mimic a date range over which we can iterate with an each
 *    iterator. Ranges can be used for any Java object which implements
 *    java.lang.Comparable for comparison, and also have methods next()
 *    and previous() to return the next / previous item in the range.
 */

import java.text.*
import java.util.*

class CalendarCategory extends GregorianCalendar {

    static GregorianCalendar next(GregorianCalendar cal) {
        cal.roll(Calendar.DAY_OF_YEAR, true)
        return cal
    }

    static GregorianCalendar previous(GregorianCalendar cal) {
        cal.roll(Calendar.DAY_OF_YEAR, false)
        return cal
    }
}

def formatter = new SimpleDateFormat("EEE MMM dd, yyyy")

use(CalendarCategory.class) {
    def start = new GregorianCalendar(2006, 10, 24)
    def end = new GregorianCalendar(2006, 10, 30)
    def calRange = start..end
    calRange.each { gCal ->
        println "Date: ${formatter.format(gCal.getTime())}"
    }
}
