package extras

/**
 *  Currying closures.
 */

def multiply = { x, y -> return x * y }

println "multiply: ${multiply(3, 4)}"

def triple = multiply.curry(3)
def quadruple = multiply.curry(4)

def map(f, list) {
    return list.collect(f)
}

println "map: ${map(triple, [1, 2, 3, 4])}"
