package extras

/**
 *  Zip together three lists so that [x1, x2, ... ], [y1, y2, ... ]
 *    and [z1, z2, ... ] produce [[x1, y1, z1], [x2, y2, z2], ... ].
 */

import fp.*

def map = Functor.map
def zip = Functor.zip

def flat = { list -> return list.flatten() }

def l1 = [1, 2, 3]
def l2 = [4, 5, 6]
def l3 = [7, 8, 9]

def zip3 = { list1, list2, list3 ->
	return map(flat, zip(zip(list1, list2), list3))
}
def res = zip3(l1, l2, l3)
println "res: ${res}"
