package extras

import fp.*

	// alias
def bEq = Functor.bEq
def bNe = Functor.bNe
def bLe = Functor.bLe

def takeWhile = Functor.takeWhile

def hasCommon = { pred, list1, list2 ->
    return list1.any {item1 -> return list2.any {item2 -> return pred(item1, item2)} }
}

def ex1 = [11, 12, 13, 14]
def ex2 = [15, 16]
def ex3 = [13, 14, 15]
       
println "hasCommon: ${hasCommon(bEq, ex1, ex2)}"
println "hasCommon: ${hasCommon(bEq, ex1, ex3)}"

def common = { pred, list1, list2 ->
    return list1.findAll {item1 -> return list2.any {item2 -> return pred(item1, item2)} }
}

println "common: ${common(bEq, ex1, ex2)}"
println "common: ${common(bEq, ex1, ex3)}"

def clo = { pred, list1, list2 ->
	return takeWhile({item2 -> return list1.every {item1 -> return pred(item1, item2)}}, list2)
    //return list1.findAll {item1 -> return list2.any {item2 -> return pred(item1, item2)} }
}

println "clo: ${clo(bLe, ex1, ex2)}"
println "clo: ${clo(bLe, ex1, ex3)}"
