import java.util.*
import console.*

def head(list) {
    return (list.size() == 0) ? null : list[0]
}

def tail(list) {
    def size = list.size()
    return (size == 0) ? [] : list[1..<size]
}

def cons(item, list) {
    def copy = list
    copy.add(0, item)
    return copy
}

def maxList(list) {
    def max = list[0]
    for(k in 1..<list.size())
        if(max < list[k])
            max = list[k]
    return max
}

def intToRoman(arabic) {
    return changeRoman(arabic, [1 : 'I', 5 : 'V', 10 : 'X', 50 : 'L', 100 : 'C', 500 : 'D', 1000 : 'M'])
}

def changeRoman(arabic, romanMap) {
    def keyList = romanMap.keySet().toArray()
    def max = maxList(keyList)
    if(arabic == 0)
        return []
    else if(arabic < max) {
        def copy = [:]
        copy.putAll(romanMap)
        copy.remove(max)
        return changeRoman(arabic, copy)
    } else {
        return cons(romanMap[max], changeRoman(arabic - max, romanMap))
    }
}

def romanToInt(roman) {
    def ROMAN = ['M' : 1000, 'D' : 500, 'C' : 100, 'L' : 50, 'X' : 10, 'V' : 5, 'I' : 1]
    def arabic = roman.toList().inject(0) { previous, romanDigit -> return previous + ROMAN[romanDigit] }
    return arabic
}

def addRoman(roman1, roman2) {
    return intToRoman(romanToInt(roman1) + romanToInt(roman2))
}

def subtractRoman(roman1, roman2) {
    return intToRoman(romanToInt(roman1) - romanToInt(roman2))
}

def EXPRESSION = '(M*D*C*L*X*V*I*)\\s([+-])\\s(M*D*C*L*X*V*I*)'
print "Enter Roman expression: "
def expr = Console.readLine()

if(expr =~ EXPRESSION) {
    def matcher = expr =~ EXPRESSION
    matcher.matches()
    
    def result = null
    switch(matcher[0][2]) {
        case '+' :
            result = addRoman(matcher[0][1], matcher[0][3])
            break;
        case '-' :
            result = subtractRoman(matcher[0][1], matcher[0][3])
            break;
    }
    println "Result: ${result.join('')}"
    
} else
    println "Bad expression: ${expr}"
