import console.*

def zeller(day, month, year) {
    def k = day
    def m = month
    def y = year
    
    if(month < 3) {
        m = month + 10
        y = year - 1
    } else
        m = month - 2
    
    def d = y % 100
    def c = y.intdiv(100)
    
    def z = (26 * m - 2).intdiv(10) + k + d + d.intdiv(4) + c.intdiv(4) - 2 * c + 77
    
    return z % 7
}

def julian(day, month, year) {
    def mm = month
    def yy = year
    
    if(mm > 2)
        mm -= 3
    else {
        mm += 9
        yy--
    }
    
    def cent = yy.intdiv(100)
    def yr = yy % 100
    
    return ((146097 * cent).intdiv(4)) + ((1461 * yr).intdiv(4)) + (153 * mm + 2).intdiv(5) + day + 1721119
}

def difference(day1, month1, year1, day2, month2, year2) {
    return julian(day2, month2, year2) - julian(day1, month1, year1)
}

def daysInMonth(month, year) {
    def year2 = year
    def month2 = month + 1
    if(month2 > 12) {
        month2 = 1
        year2++
    }
    
    return difference(1, month, year, 1, month2, year2)
}


/**
def dayName(zell) {
    def DAYNAMES = [ 0 : 'Sunday',	1 : 'Monday',	2 : 'Tuesday',
                     3 : 'Wednesday',	4 : 'Thursday',	5 : 'Friday',
                     6 : 'Saturday'
                   ]
    return DAYNAMES[zell]
}
**/

def monthName(month) {
    def MONTHNAMES = [ 1 : 'January',	 2 : 'February',	 3 : 'March',
                       4 : 'April',	 5 : 'May',		 6 : 'June',
                       7 : 'July',	 8 : 'August',		 9 : 'September',
                      10 : 'October',	11 : 'November',	12 : 'December'
                     ]
    return MONTHNAMES[month]
}

def printCalendar(month, year) {
    println "\t${monthName(month)} ${year}"
    println()
    
    println '  S  M  T  W  T  F  S'
    println '---------------------'
    
    def zell = zeller(1, month, year)
    if(zell > 0)
        1.upto(zell) { num -> print '   ' }
    1.upto(daysInMonth(month, year)) { day ->
        printf('%3d', [day])
        zell++
        if(zell == 7) {
            zell = 0
            println()
        }
    }
}

print 'Enter the date as MM/YYYY: '
def date = Console.readLine()

def tokens = date.tokenize('/')
def month = tokens[0].toInteger()
def year = tokens[1].toInteger()

printCalendar(month, year)
//def zell = zeller(day, month, year)

//printf('%s %d %s %d\n', [dayName(zell), day, monthName(month), year])
