import java.util.*

def addLocalEnvironment(localEnvironment, variable, value) {
    localEnvironment[variable] = value
}

def getVariablesLocalEnvironment(localEnvironment) {
    return new ArrayList(localEnvironment.keySet())
}

def getValueLocalEnvironment(localEnvironment, variable) {
    return localEnvironment[variable]
}

def addBlock(environment) {
    environment << [ : ]
}

def removeBlock(environment) {
    environment.pop()
}

def add(environment, variable, value) {
    addLocalEnvironment(environment[environment.size() - 1], variable, value)
}

def lookup(environment, variable) {
    for(k in 0..<environment.size()) {
        def index = environment.size() - 1 - k
        def localEnv = environment[index]
        def val = getValueLocalEnvironment(localEnv, variable)
        if(val != null)
            return val
    }
    return null
}



environment = []
addBlock(environment)

add(environment, 'hours', 1)
add(environment, 'minutes', 2)

println "lookup(minutes): ${lookup(environment, 'minutes')}"

addBlock(environment)
add(environment, 'minutes', 3)

println "lookup(hours): ${lookup(environment, 'hours')}"
println "lookup(minutes): ${lookup(environment, 'minutes')}"
