/**
 *  A bank account represented by two properties for the account
 *    number and the account balance. Private properties do not
 *    auto-generate getters and setters. Any getter method introduced
 *    into the class makes the property read-only. Any setter makes
 *    the property write-only. Both make the property fully accessible.
 *
 *  Private properties also imply that a constructor application with
 *    named parameters will not operate correctly unless the setters
 *    are provided and are public.
 */

class Account {
    
    def getBalance() {
        return balance
    }
    
    def setNumber(number) {
        this.number = number
    }
    
    def setBalance(balance) {
        this.balance = balance
    }
    
    def credit(amount) {
        balance += amount
    }
    
    def debit(amount) {		// only if there are sufficient funds
        if(balance >= amount)
            balance -= amount
    }
    
// ---------- properties ----------------------------------

    private number			// account number
    private balance			// current balance
}

	//  Create an instance
def acc = new Account(number : 'ABC123', balance : 1200)

	//  However, the balance property is read-only through the public getter
println "Account balance: ${acc.balance}"
