/**
 *  Applying to all -- mapping. A mapping is used to transform all
 *    the elements of a list. Combining maps and compositions.
 */

	//  map closure
def map = { clos, list -> return list.collect(clos) }

	//  composition closure
def composition = { f, g, x -> return f(g(x)) }

	//  Multiply closure and two instances
def multiply = { x, y -> return x * y }

def triple = multiply.curry(3)
def quadruple = multiply.curry(4)

	//  composition of two maps...
def composeMapMap = composition.curry(map.curry(triple), map.curry(quadruple))

def tableComposeMapMap = composeMapMap([1, 2, 3, 4])

println "tableComposeMapMap: ${tableComposeMapMap}"

	//  ...equivalent to the map of a composition
def mapCompose = map.curry(composition.curry(triple, quadruple))

def tableMapCompose = mapCompose([1, 2, 3, 4])

println "tableMapCompose: ${tableMapCompose}"
