/**
 *  Compute the net price of a Book, taking account of the tax rate set
 *    by the governmebt anf the discount rate set by the distributor.
 */

	// Book class and instance
class Book {

    def name	// properties
    def author
    def price
    def category
}

def bk = new Book(name : 'Groovy', author : 'KenB', price : 25, category : 'CompSci')

	// constants
def discountRate = 0.1
def taxRate = 0.17

	//  basic closures
def rMultiply = { y, x -> return x * y }
def lMultiply = { x, y -> return x * y }

def composition = { f, g, x -> return f(g(x)) }

	//  book closures
def calcDiscountedPrice = rMultiply.curry(1 - discountRate)

def calcTax = rMultiply.curry(1 + taxRate)

def calcNetPrice = composition.curry(calcTax, calcDiscountedPrice)

	//  now calculate net price
def netPrice = calcNetPrice(bk.price)

println "netPrice: ${netPrice}"
