/**
 *  A company with any number of employees. Each employee is responsible
 *    to a team leader who, in turn, manages a team of staff.
 */

import java.util.*
import fp.*

class Employee {

    def String toString() {
        return "Employee: ${id} ${name}"
    }
    
    def addToTeam(employee) {
        staff[employee.id] = employee
        employee.manager = this
    }
    
// ---------- properties ----------------------------------

    def id
    def name
    def staff = [ : ]
    def manager = null
}

class Company {

    def hireEmployee(employee) {
        employees[employee.id] = employee
    }
    
// ---------- properties ----------------------------------

    def name
    def employees = [ : ]
}


def displayStaff(co) {
    println "Company: ${co.name}"
    println "===================="
    co?.employees.each { entry -> println "  ${entry.value}" }
}



def co = new Company(name : 'Napier')

def emp1 = new Employee(id : 123, name : 'KenB')
def emp2 = new Employee(id : 456, name : 'JohnS')
def emp3 = new Employee(id : 789, name : 'JonK')

co.hireEmployee(emp1)
co.hireEmployee(emp2)
co.hireEmployee(emp3)

emp3.addToTeam(emp1)
emp3.addToTeam(emp2)

displayStaff(co)


def hasManager = { employee -> return (employee.manager != null) }

def staff = co.employees.values().toList()

println "Every employee has a manager?: ${Functor.forAll.call(hasManager, staff)}"

	// Now make JonK a member of own team
emp3.addToTeam(emp3)
println "Every employee has a manager?: ${Functor.forAll.call(hasManager, staff)}"
